/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.t2framework.commons.Disposable;
import org.t2framework.commons.Disposer;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;

public class PatternUtil {
    private static final Map<String, Pattern> patternCache = CollectionsUtil.newHashMap();

    protected PatternUtil() {
    }

    public static Pattern getPattern(String regex) {
        return PatternUtil.getPattern(regex, 0);
    }

    public static Pattern getPattern(String regex, int flag) {
        Assertion.notNull(regex);
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex, flag);
            patternCache.put(regex, pattern);
        }
        return pattern;
    }

    public static boolean matches(String regex, CharSequence value) {
        Assertion.notNull(regex);
        Pattern pattern = PatternUtil.getPattern(regex);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static void clearPatternCache() {
        patternCache.clear();
    }

    public static List<Pattern> getPatterns(String[] regexes) {
        List<Pattern> patterns = CollectionsUtil.newArrayList();
        for (String regex : regexes) {
            if (regex == null) continue;
            patterns.add(PatternUtil.getPattern(regex));
        }
        return patterns;
    }

    static {
        Disposer.add(new Disposable(){

            @Override
            public void dispose() {
                PatternUtil.clearPatternCache();
            }
        });
    }
}

