/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import org.t2framework.commons.util.StringUtil;

public class JSONTokenizer {
    public static final char COMMA = ',';
    public static final char COLON = ':';
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final String NULL_STRING = "null";
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";
    public static final char START_BRACKET = '[';
    public static final char END_BRACKET = ']';
    public static final char START_BRACE = '{';
    public static final char END_BRACE = '}';
    protected final String orgString;
    protected final int orgLength;
    protected String tokenString;
    protected int pos;
    protected int nextPos;
    protected TokenType type = TokenType.EOF;

    public JSONTokenizer(String s) {
        this.orgString = s != null ? s : NULL_STRING;
        this.orgLength = this.orgString.length();
        this.tokenString = this.orgString;
        this.prepare(0);
    }

    protected void prepare(int i) {
        if (i < this.orgLength) {
            char ch = this.orgString.charAt(i);
            if (ch == '{') {
                this.type = TokenType.START_BRACE;
            } else if (ch == '}') {
                this.type = TokenType.END_BRACE;
            } else if (ch == '[') {
                this.type = TokenType.START_BRACKET;
            } else if (ch == ']') {
                this.type = TokenType.END_BRACKET;
            }
            this.pos = i;
            this.nextPos = i + 1;
        } else {
            this.type = TokenType.EOF;
        }
    }

    public TokenType nextToken() {
        if (this.type == TokenType.EOF) {
            return TokenType.EOF;
        }
        String s = this.tokenString;
        TokenType retType = TokenType.EOF;
        boolean key = true;
        for (int i = this.nextPos; i < this.orgLength; ++i) {
            char ch = this.orgString.charAt(i);
            if (JSONTokenizer.isIgnorable(ch)) continue;
            if (ch == '{') {
                s = this.getElement(this.nextPos, this.orgLength - 1);
                retType = TokenType.START_BRACE;
                this.prepare(i);
                key = true;
                break;
            }
            if (ch == '[') {
                s = this.getElement(this.nextPos, this.orgLength - 1);
                retType = TokenType.START_BRACKET;
                this.prepare(i);
                key = true;
                break;
            }
            if (ch == ':') {
                if (i == this.orgLength - 1) {
                    throw new IllegalStateException();
                }
                s = this.getElement(this.nextPos, i - 1);
                this.type = retType = TokenType.COLON;
                this.prepare(i);
                key = true;
                break;
            }
            if (ch == ',') {
                if (i == this.orgLength - 1) {
                    throw new IllegalArgumentException();
                }
                s = this.getElement(this.nextPos, i - 1);
                retType = this.isObjectOrArrayEnd(i - 1) ? TokenType.END_COMMA : TokenType.COMMA;
                this.type = retType;
                this.prepare(i);
                key = false;
                break;
            }
            if (ch == ']') {
                this.type = i == this.orgLength - 1 ? TokenType.EOF : TokenType.END_BRACKET;
                retType = TokenType.END_BRACKET;
                s = this.getElement(this.nextPos, i - 1);
                this.prepare(i);
                key = false;
                break;
            }
            if (ch != '}') continue;
            this.type = i == this.orgLength - 1 ? TokenType.EOF : TokenType.END_BRACE;
            retType = TokenType.END_BRACE;
            s = this.getElement(this.nextPos, i - 1);
            this.prepare(i);
            key = false;
            break;
        }
        s = this.removeIgnorable(s);
        this.tokenString = key ? JSONTokenizer.unquote(s) : s;
        return retType;
    }

    protected boolean isObjectOrArrayEnd(int pos) {
        for (int i = pos; 0 < i; --i) {
            char c = this.orgString.charAt(i);
            if (JSONTokenizer.isIgnorable(c)) continue;
            return c == '}' || c == ']';
        }
        return false;
    }

    protected String removeIgnorable(String s) {
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        for (int pos1 = 0; pos1 < s.length(); ++pos1) {
            if (JSONTokenizer.isIgnorable(s.charAt(pos1))) continue;
            return s.substring(pos1);
        }
        return "";
    }

    protected String getElement(int orgStartPos, int orgEndPos) {
        char ch;
        int endPos;
        char ch2;
        int startPos;
        for (startPos = orgStartPos; startPos < orgEndPos && JSONTokenizer.isIgnorable(ch2 = this.orgString.charAt(startPos)); ++startPos) {
        }
        for (endPos = orgEndPos; startPos < endPos && JSONTokenizer.isIgnorable(ch = this.orgString.charAt(endPos)); --endPos) {
        }
        return this.orgString.substring(startPos, endPos + 1);
    }

    protected static boolean isIgnorable(char ch) {
        boolean ret = false;
        switch (ch) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    public static String unquote(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (JSONTokenizer.isQuoted(str, '\"')) {
            return JSONTokenizer.chopQuote(str);
        }
        if (JSONTokenizer.isQuoted(str, '\'')) {
            return JSONTokenizer.chopQuote(str);
        }
        return str;
    }

    public static String chopQuote(String str) {
        return str.substring(1, str.length() - 1);
    }

    protected static boolean isQuoted(String str, char quote) {
        return str.indexOf(quote) == 0 && str.lastIndexOf(quote) > 0;
    }

    public String getToken() {
        return this.tokenString;
    }

    public TokenType currentTokenType() {
        return this.type;
    }

    public static enum TokenType {
        START_BRACE{

            public String toString() {
                return "{";
            }
        }
        ,
        END_BRACE{

            public String toString() {
                return "}";
            }
        }
        ,
        START_BRACKET{

            public String toString() {
                return "[";
            }
        }
        ,
        END_BRACKET{

            public String toString() {
                return "]";
            }
        }
        ,
        COMMA{

            public String toString() {
                return ",";
            }
        }
        ,
        COLON{

            public String toString() {
                return ":";
            }
        }
        ,
        END_COMMA{

            public String toString() {
                return ",";
            }
        }
        ,
        EOF;

    }
}

