/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.BeanDescFactory;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.ConverterUtil;
import org.t2framework.commons.util.JSONTokenizer;
import org.t2framework.commons.util.StringUtil;

public class JSONSerializer {
    protected static JsonValueConverter converter;
    private static final JsonValueConverter DEFAULT_CONVERTER;

    public static <T> String serialize(T o) {
        StringBuilder builder = new StringBuilder(100);
        JSONSerializer.appendSerializeObject(builder, o);
        return builder.toString();
    }

    public static void appendSerializeObject(StringBuilder builder, Object o) {
        if (o == null) {
            builder.append("null");
        } else if (o instanceof String) {
            builder.append(JSONSerializer.quote((String)o));
        } else if (Enum.class.isAssignableFrom(o.getClass())) {
            Enum e = (Enum)o;
            builder.append(JSONSerializer.quote(e.name()));
        } else if (o instanceof Float) {
            JSONSerializer.appendSerializeFloat(builder, (Float)o);
        } else if (o instanceof Double) {
            JSONSerializer.appendSerializeDouble(builder, (Double)o);
        } else if (o instanceof Number) {
            builder.append(o.toString());
        } else if (o instanceof Boolean) {
            JSONSerializer.appendSerializeBoolean(builder, (Boolean)o);
        } else if (o instanceof Collection) {
            JSONSerializer.appendSerializeArray(builder, ((Collection)o).toArray());
        } else if (o instanceof Object[]) {
            JSONSerializer.appendSerializeArray(builder, (Object[])o);
        } else if (o instanceof Map) {
            JSONSerializer.appendSerializeMap(builder, (Map)o);
        } else if (o.getClass().isArray()) {
            JSONSerializer.appendSerializeObjectArray(builder, o);
        } else {
            JSONSerializer.appendSerializeBean(builder, o);
        }
    }

    public static void appendSerializeFloat(StringBuilder builder, Float f) {
        if (f.isNaN() || f.isInfinite()) {
            throw new IllegalArgumentException(f.toString());
        }
        builder.append(f.toString());
    }

    public static void appendSerializeDouble(StringBuilder builder, Double d) {
        if (d.isNaN() || d.isInfinite()) {
            throw new IllegalArgumentException(d.toString());
        }
        builder.append(d.toString());
    }

    public static void appendSerializeBoolean(StringBuilder builder, Boolean b) {
        if (Boolean.TRUE.equals(b)) {
            builder.append("true");
        } else {
            builder.append("false");
        }
    }

    public static void appendSerializeArray(StringBuilder builder, Object[] array) {
        int length = array.length;
        builder.append('[');
        for (int i = 0; i < length; ++i) {
            JSONSerializer.appendSerializeObject(builder, array[i]);
            builder.append(',');
        }
        if (length > 0) {
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
    }

    public static void appendSerializeMap(StringBuilder builder, Map<?, ?> map) {
        builder.append('{');
        for (String key : map.keySet()) {
            builder.append(JSONSerializer.quote(key) + ':');
            JSONSerializer.appendSerializeObject(builder, map.get(key));
            builder.append(',');
        }
        if (map.size() > 0) {
            builder.setLength(builder.length() - 1);
        }
        builder.append('}');
    }

    public static <T> void appendSerializeBean(StringBuilder builder, T t) {
        builder.append('{');
        BeanDesc<T> beanDesc = BeanDescFactory.getBeanDesc(t);
        for (PropertyDesc<T> pd : beanDesc.getAllPropertyDesc()) {
            builder.append(pd.getPropertyName() + ':');
            JSONSerializer.appendSerializeObject(builder, pd.getValue(t));
            builder.append(',');
        }
        if (beanDesc.getPropertyDescSize() > 0) {
            builder.setLength(builder.length() - 1);
        }
        builder.append('}');
    }

    public static void appendSerializeObjectArray(StringBuilder builder, Object o) {
        int length = Array.getLength(o);
        builder.append('[');
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(o, i);
            JSONSerializer.appendSerializeObject(builder, value);
            builder.append(',');
        }
        if (length > 0) {
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
    }

    public static String quote(String str) {
        if (str == null || str.length() == 0) {
            return "\"\"";
        }
        char current = '\u0000';
        int len = str.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block8: for (int i = 0; i < len; ++i) {
            current = str.charAt(i);
            switch (current) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(current);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (current < ' ') {
                        String t = "000" + Integer.toHexString(current);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(current);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static boolean isObject(String str) {
        return str.indexOf(123) == 0 && str.lastIndexOf(125) == str.length() - 1;
    }

    public static boolean isArray(String str) {
        return str.indexOf(91) == 0 && str.lastIndexOf(93) == str.length() - 1;
    }

    public static boolean isString(String str) {
        if (StringUtil.isEmpty(str) && str.length() < 2) {
            return false;
        }
        int last = str.length() - 1;
        return str.indexOf(39) == 0 && str.lastIndexOf(39) == last || str.indexOf(34) == 0 && str.lastIndexOf(34) == last;
    }

    public static Object eval(String str) {
        JSONTokenizer tokenizer = new JSONTokenizer(str);
        JSONTokenizer.TokenType type = tokenizer.currentTokenType();
        JsonContext context = JSONSerializer.createJsonContext(type);
        return JSONSerializer.eval(str, tokenizer, context);
    }

    public static Object eval(String str, JSONTokenizer tokenizer, JsonContext context) {
        String key = tokenizer.getToken();
        JSONTokenizer.TokenType type = tokenizer.nextToken();
        while (type != JSONTokenizer.TokenType.EOF) {
            Object value;
            JsonContext child;
            String token = tokenizer.getToken();
            if (type == JSONTokenizer.TokenType.START_BRACE) {
                child = JSONSerializer.createChildJsonContext(context, key, type);
                context.add(key, JSONSerializer.eval(token, tokenizer, child));
                key = null;
            } else if (type == JSONTokenizer.TokenType.START_BRACKET) {
                child = JSONSerializer.createChildJsonContext(context, key, type);
                context.add(key, JSONSerializer.eval(token, tokenizer, child));
                key = null;
            } else if (type == JSONTokenizer.TokenType.COLON) {
                key = token;
            } else if (type == JSONTokenizer.TokenType.COMMA) {
                value = JSONSerializer.convertValue(token);
                context.add(key, value);
            } else if (type == JSONTokenizer.TokenType.END_COMMA) {
                key = token;
            } else if (type == JSONTokenizer.TokenType.END_BRACKET) {
                if (key != null) {
                    value = JSONSerializer.convertValue(token);
                    context.add(key, value);
                }
                if (context.isChild()) {
                    return context.get();
                }
            } else if (type == JSONTokenizer.TokenType.END_BRACE) {
                if (key != null) {
                    value = JSONSerializer.convertValue(token);
                    context.add(key, value);
                }
                if (context.isChild()) {
                    return context.get();
                }
            }
            type = tokenizer.nextToken();
        }
        return context.get();
    }

    private static JsonContext createJsonContext(JSONTokenizer.TokenType type) {
        return JSONSerializer.createJsonContext(new JsonContext(), type);
    }

    private static JsonContext createJsonContext(JsonContext context, JSONTokenizer.TokenType type) {
        if (type == JSONTokenizer.TokenType.START_BRACE) {
            context.setMap(new HashMap<String, Object>());
        } else if (type == JSONTokenizer.TokenType.START_BRACKET) {
            context.setList(new ArrayList<Object>());
        } else {
            throw new IllegalStateException();
        }
        return context;
    }

    private static JsonContext createChildJsonContext(JsonContext parent, String parentkey, JSONTokenizer.TokenType type) {
        JsonContext child = new JsonContext(parentkey);
        return JSONSerializer.createJsonContext(child, type);
    }

    private static Object convertValue(String token) {
        return converter != null ? converter.convert(token) : DEFAULT_CONVERTER.convert(token);
    }

    public static void setJsonValueConverter(JsonValueConverter converter) {
        JSONSerializer.converter = converter;
    }

    static {
        DEFAULT_CONVERTER = new JsonValueConverter(){

            @Override
            public Object convert(String s) {
                if (StringUtil.isEmpty(s)) {
                    return s;
                }
                if ("false".equals(s) || "true".equals(s)) {
                    return ConverterUtil.convertAsBoolean(s);
                }
                if ("null".equals(s)) {
                    return null;
                }
                if (JSONSerializer.isString(s)) {
                    return JSONTokenizer.chopQuote(s);
                }
                if (this.isNumberLike(s)) {
                    try {
                        return new BigDecimal(s);
                    }
                    catch (NumberFormatException e) {
                        return s;
                    }
                }
                return s;
            }

            protected boolean isNumberLike(String s) {
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (Character.isDigit(c) || c == '.' || c == '+' || c == '-' || c == 'e' || c == 'E') continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static interface JsonValueConverter {
        public Object convert(String var1);
    }

    public static class JsonContext {
        protected Map<String, Object> ownmap = null;
        protected List<Object> ownlist = null;
        protected final String parentKey;
        protected final boolean child;

        public JsonContext() {
            this.parentKey = null;
            this.child = false;
        }

        public JsonContext(String parentKey) {
            this.parentKey = parentKey;
            this.child = true;
        }

        public void setList(List<Object> list) {
            this.ownlist = list;
        }

        public void setMap(Map<String, Object> map) {
            this.ownmap = map;
        }

        public void add(String key, Object value) {
            if (this.ownmap != null) {
                this.ownmap.put(key, value);
            } else {
                this.ownlist.add(value);
            }
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public boolean isChild() {
            return this.child;
        }

        public Object get() {
            if (this.ownmap != null) {
                return this.ownmap;
            }
            return this.ownlist;
        }
    }
}

