/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.util.Map;
import org.t2framework.commons.Constants;
import org.t2framework.commons.util.CollectionsUtil;

public class AutoboxingUtil {
    private static Map<Class<?>, Object> primitiveToDefaultValueMap = CollectionsUtil.newHashMap();

    public static int toPrimitiveInt(Integer i) {
        if (i == null) {
            return 0;
        }
        return i;
    }

    public static double toPrimitiveDouble(Double d) {
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public static float toPrimitiveFloat(Float f) {
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public static long toPrimitiveLong(Long l) {
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public static short toPrimitiveShort(Short s) {
        if (s == null) {
            return 0;
        }
        return s;
    }

    public static char toPrimitiveCharacter(Character c) {
        if (c == null) {
            return Constants.CHAR_DEFAULT_VALUE.charValue();
        }
        return c.charValue();
    }

    public static Integer[] toIntegerArray(int[] array) {
        if (array == null || array.length == 0) {
            return Constants.EMPTY_INT_ARRAY;
        }
        Integer[] ret = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Double[] toDoubleArray(double[] array) {
        if (array == null || array.length == 0) {
            return Constants.EMPTY_DOUBLE_ARRAY;
        }
        Double[] ret = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = array[i];
        }
        return ret;
    }

    public static Object getDefaultValueIfNull(Class<?> type, Object value) {
        if (value != null) {
            return value;
        }
        if (type == Integer.TYPE) {
            return Constants.INT_DEFAULT_VALUE;
        }
        if (type == Double.TYPE) {
            return Constants.DOUBLE_DEFAULT_VALUE;
        }
        if (type == Long.TYPE) {
            return Constants.LONG_DEFAULT_VALUE;
        }
        if (type == Float.TYPE) {
            return Constants.FLOAT_DEFAULT_VALUE;
        }
        if (type == Short.TYPE) {
            return Constants.SHORT_DEFAULT_VALUE;
        }
        if (type == Boolean.TYPE) {
            return Constants.BOOLEAN_DEFAULT_VALUE;
        }
        if (type == Byte.TYPE) {
            return Constants.BYTE_DEFAULT_VALUE;
        }
        return value;
    }

    public static Object getDefaultPrimitiveValue(Class<?> clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return null;
        }
        return primitiveToDefaultValueMap.get(clazz);
    }

    static {
        primitiveToDefaultValueMap.put(Void.TYPE, null);
        primitiveToDefaultValueMap.put(Character.TYPE, Constants.CHAR_DEFAULT_VALUE);
        primitiveToDefaultValueMap.put(Byte.TYPE, Constants.BYTE_DEFAULT_VALUE);
        primitiveToDefaultValueMap.put(Short.TYPE, Constants.SHORT_DEFAULT_VALUE);
        primitiveToDefaultValueMap.put(Integer.TYPE, Constants.INT_DEFAULT_VALUE);
        primitiveToDefaultValueMap.put(Long.TYPE, Constants.LONG_DEFAULT_VALUE);
        primitiveToDefaultValueMap.put(Double.TYPE, Constants.DOUBLE_DEFAULT_VALUE);
        primitiveToDefaultValueMap.put(Float.TYPE, Constants.FLOAT_DEFAULT_VALUE);
        primitiveToDefaultValueMap.put(Boolean.TYPE, Constants.BOOLEAN_DEFAULT_VALUE);
    }
}

