/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.ConstructorDesc;
import org.t2framework.commons.meta.InstanceFactory;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.NameDesc;
import org.t2framework.commons.meta.PackageDesc;
import org.t2framework.commons.meta.PackageDescHolder;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.meta.impl.BeanDescSupport;
import org.t2framework.commons.meta.impl.ClassDescImpl;
import org.t2framework.commons.meta.impl.ConstructorDescImpl;
import org.t2framework.commons.meta.impl.InstanceFactoryImpl;
import org.t2framework.commons.meta.impl.MethodDescImpl;
import org.t2framework.commons.meta.impl.PackageDescImpl;
import org.t2framework.commons.meta.impl.PropertyDescImpl;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.JavaBeansUtil;
import org.t2framework.commons.util.Reflections;

public class BeanDescImpl<T>
implements BeanDesc<T> {
    protected static final List<Config> EMPTY_CONFIG_LIST = CollectionsUtil.emptyList();
    protected ClassDesc<T> classDesc;
    protected ConstructorDesc<T> constructorDesc;
    protected NameDesc<T> nameDesc;
    protected Map<String, PropertyDesc<T>> propertyDescMap;
    protected List<PropertyDesc<T>> propertyDescList;
    protected Map<String, List<MethodDesc>> methodDescMap;
    protected List<MethodDesc> methodDescList;
    protected T component;
    protected BeanDescSupport<T> support;
    protected PackageDesc packageDesc;
    protected boolean singleton;
    protected InstanceFactory<T> instanceFactory = new InstanceFactoryImpl();

    public BeanDescImpl(Class<? extends T> componentClass) {
        this(componentClass, null);
    }

    public BeanDescImpl(Class<? extends T> componentClass, PackageDescHolder holder) {
        Assertion.notNull(componentClass);
        this.init(componentClass, holder);
    }

    public BeanDescImpl(ClassDesc<T> classDesc) {
        this(classDesc, null);
    }

    public BeanDescImpl(ClassDesc<T> classDesc, PackageDescHolder holder) {
        this.setClassDesc(Assertion.notNull(classDesc));
        this.init(classDesc.getComponentClass(), holder);
    }

    protected void init(Class<? extends T> componentClass, PackageDescHolder holder) {
        this.init0();
        if (this.classDesc == null) {
            this.analyzeClasses(componentClass);
        }
        this.analyzeConstructors();
        this.analyzePropertiesAndMethods(componentClass);
        if (holder != null) {
            this.analyzePackages(holder);
        }
    }

    protected void init0() {
        this.propertyDescMap = CollectionsUtil.newHashMap();
        this.propertyDescList = CollectionsUtil.newArrayList();
        this.methodDescMap = CollectionsUtil.newHashMap();
        this.methodDescList = CollectionsUtil.newArrayList();
        this.support = new BeanDescSupport(this);
    }

    protected void analyzePackages(PackageDescHolder holder) {
        Class<T> c = this.getClassDesc().getComponentClass();
        String pkgname = Reflections.PackageUtil.getPackageName(c);
        this.packageDesc = holder.getPackageDesc(pkgname);
        if (this.packageDesc == null) {
            this.packageDesc = new PackageDescImpl(this);
            holder.addPackageDesc(this.packageDesc);
        } else {
            this.packageDesc.addBeanDesc(this);
        }
    }

    protected void analyzeClasses(Class<? extends T> componentClass) {
        this.setClassDesc(new ClassDescImpl<T>(componentClass));
    }

    protected void setClassDesc(ClassDesc<T> classDesc) {
        this.classDesc = classDesc;
    }

    protected void analyzePropertiesAndMethods(Class<? extends T> componentClass) {
        for (Method m : componentClass.getMethods()) {
            String propertyName;
            String methodName = m.getName();
            if (this.support.isIgnorableMethod(m)) continue;
            if (JavaBeansUtil.isGetMethod(methodName, m)) {
                propertyName = JavaBeansUtil.decapitalize(methodName.substring("get".length()));
                this.setReadMethod(m, propertyName);
                continue;
            }
            if (JavaBeansUtil.isIsMethod(methodName, m)) {
                propertyName = JavaBeansUtil.decapitalize(methodName.substring("is".length()));
                this.setReadMethod(m, propertyName);
                continue;
            }
            if (JavaBeansUtil.isSetMethod(methodName, m)) {
                propertyName = JavaBeansUtil.decapitalize(methodName.substring("set".length()));
                this.setWriteMethod(m, propertyName);
                continue;
            }
            MethodDescImpl methodDesc = new MethodDescImpl(m);
            this.addMethodDesc(methodDesc);
        }
    }

    protected void setReadMethod(Method readMethod, String propertyName) {
        PropertyDesc<T> propertyDesc = this.getPropertyDesc(propertyName);
        if (propertyDesc == null) {
            propertyDesc = new PropertyDescImpl<T>(this.getClassDesc(), readMethod.getReturnType(), propertyName);
            this.addPropertyDesc(propertyDesc);
        }
        propertyDesc.setPropertyName(propertyName);
        propertyDesc.setReadMethod(readMethod);
    }

    protected void setWriteMethod(Method writeMethod, String propertyName) {
        PropertyDesc<T> propertyDesc = this.getPropertyDesc(propertyName);
        if (propertyDesc == null) {
            Class<?> propertyType = writeMethod.getParameterTypes()[0];
            propertyDesc = new PropertyDescImpl<T>(this.getClassDesc(), propertyType, propertyName);
            propertyDesc.setPropertyType(propertyType);
            this.addPropertyDesc(propertyDesc);
        }
        propertyDesc.setPropertyName(propertyName);
        propertyDesc.setWriteMethod(writeMethod);
    }

    protected void analyzeConstructors() {
        ClassDesc<T> classDesc = this.getClassDesc();
        ConstructorDescImpl<T> constructorDesc = new ConstructorDescImpl<T>(classDesc);
        this.setConstructorDesc(constructorDesc);
    }

    @Override
    public ClassDesc<T> getClassDesc() {
        return this.classDesc;
    }

    @Override
    public Class<? extends T> getComponentClass() {
        return this.classDesc.getComponentClass();
    }

    @Override
    public MethodDesc getMethodDesc(String methodName) {
        List<MethodDesc> list = this.methodDescMap.get(methodName);
        return list != null && list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public List<MethodDesc> getMethodDescs(String methodName) {
        return this.methodDescMap.get(methodName);
    }

    @Override
    public PropertyDesc<T> getPropertyDesc(String propertyName) {
        return this.propertyDescMap.get(propertyName);
    }

    @Override
    public ConstructorDesc<T> getConstructorDesc() {
        return this.constructorDesc;
    }

    protected void setConstructorDesc(ConstructorDesc<T> constructorDesc) {
        this.constructorDesc = constructorDesc;
    }

    @Override
    public T newInstance(Object ... args) {
        return this.instanceFactory.newInstance(this, args);
    }

    protected void addMethodDesc(MethodDesc desc) {
        String methodName = desc.getMethodName();
        if (!this.methodDescMap.containsKey(methodName)) {
            List list = CollectionsUtil.newArrayList();
            list.add(desc);
            this.methodDescMap.put(methodName, list);
            this.methodDescList.add(desc);
        } else {
            List<MethodDesc> list = this.methodDescMap.get(methodName);
            list.add(desc);
        }
    }

    protected void addPropertyDesc(PropertyDesc<T> pd) {
        this.propertyDescMap.put(pd.getPropertyName(), pd);
        this.propertyDescList.add(pd);
    }

    @Override
    public List<MethodDesc> getAllMethodDesc() {
        return this.methodDescList;
    }

    @Override
    public List<PropertyDesc<T>> getAllPropertyDesc() {
        return this.propertyDescList;
    }

    @Override
    public T getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(T component) {
        this.component = component;
    }

    @Override
    public NameDesc<T> getNameDesc() {
        return this.nameDesc;
    }

    @Override
    public void setNameDesc(NameDesc<T> nameDesc) {
        this.nameDesc = Assertion.notNull(nameDesc);
    }

    @Override
    public String getComponentName() {
        return this.nameDesc != null ? this.nameDesc.getIdentifier().toString() : null;
    }

    @Override
    public Class<? extends T> getEnhancedComponentClass() {
        return this.getClassDesc().getEnhancedComponentClass();
    }

    @Override
    public int getPropertyDescSize() {
        return this.propertyDescList.size();
    }

    @Override
    public void setEnhancedComponentClass(Class<? extends T> enhancedClass) {
        Assertion.notNull(enhancedClass);
        ((ClassDescImpl)this.getClassDesc()).setEnhancedComponentClass(enhancedClass);
        if (!Proxy.isProxyClass(enhancedClass)) {
            ((ConstructorDescImpl)this.getConstructorDesc()).setEnhancedComponentClass(enhancedClass);
        }
    }

    @Override
    public PackageDesc getPackageDesc() {
        return this.packageDesc;
    }

    protected BeanDescSupport<T> getBeanDescSupport() {
        return this.support;
    }

    @Override
    public boolean hasName() {
        return this.nameDesc != null;
    }

    @Override
    public Class<? extends T> getConcreteClass() {
        return this.getClassDesc().getConcreteClass();
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    @Override
    public void addConfig(Config config) {
        this.classDesc.addConfig(config);
    }

    @Override
    public Config findConfig(Class<?> clazz) {
        return this.classDesc.findConfig(clazz);
    }

    @Override
    public Iterable<Config> findConfigs(Class<?> clazz) {
        return this.classDesc.findConfigs(clazz);
    }

    @Override
    public Iterator<Config> iterator() {
        return this.classDesc.iterator();
    }

    @Override
    public boolean hasConfig() {
        return this.classDesc.hasConfig();
    }

    @Override
    public boolean hasConfig(Class<?> clazz) {
        return this.classDesc.hasConfig(clazz);
    }

    @Override
    public void setInstanceFactory(InstanceFactory<T> instanceFactory) {
        this.instanceFactory = instanceFactory;
    }
}

