/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta;

import org.t2framework.commons.Disposable;
import org.t2framework.commons.Disposer;
import org.t2framework.commons.cache.Cache;
import org.t2framework.commons.cache.CacheFactory;
import org.t2framework.commons.cache.CacheSynchronization;
import org.t2framework.commons.cache.CacheType;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.PackageDescHolder;
import org.t2framework.commons.meta.spi.BeanDescCreator;
import org.t2framework.commons.module.Modules;
import org.t2framework.commons.util.Assertion;

public class BeanDescFactory {
    protected static BeanDescCreator creator;
    private static Cache<Object, BeanDesc> cache;
    private static volatile boolean initialized;

    public static synchronized void init() {
        if (!initialized) {
            creator = Modules.getService(BeanDescCreator.class);
            Disposer.add(new Disposable(){

                @Override
                public void dispose() {
                    BeanDescFactory.clear();
                }
            });
            initialized = true;
        }
    }

    private static void initIfNeed() {
        if (!initialized) {
            BeanDescFactory.init();
        }
    }

    public static <T> BeanDesc<T> getBeanDesc(Class<? extends T> componentClass) {
        return BeanDescFactory.getBeanDesc(componentClass, BeanDescCreator.DEFAULT_PACKAGEDESC_HOLDER);
    }

    public static <T> BeanDesc<T> getBeanDesc(Class<? extends T> componentClass, PackageDescHolder holder) {
        Assertion.notNull(componentClass);
        BeanDescFactory.initIfNeed();
        BeanDesc<Class<? extends T>> beanDesc = cache.get(componentClass);
        if (beanDesc == null) {
            beanDesc = BeanDescFactory.createBeanDesc(componentClass, holder);
            cache.put(componentClass, beanDesc);
        }
        return beanDesc;
    }

    public static <T> BeanDesc<T> getBeanDesc(T t) {
        return BeanDescFactory.getBeanDesc(t, BeanDescCreator.DEFAULT_PACKAGEDESC_HOLDER);
    }

    public static <T> BeanDesc<T> getBeanDesc(T t, PackageDescHolder holder) {
        Assertion.notNull(t);
        BeanDescFactory.initIfNeed();
        BeanDesc<T> beanDesc = cache.get(t);
        if (beanDesc == null) {
            beanDesc = BeanDescFactory.createBeanDesc(t, holder);
        }
        cache.put(t, beanDesc);
        return beanDesc;
    }

    private static <T> BeanDesc<T> createBeanDesc(Class<? extends T> componentClass, PackageDescHolder holder) {
        return creator.createBeanDesc(componentClass, holder);
    }

    private static <T> BeanDesc<T> createBeanDesc(T t, PackageDescHolder holder) {
        return creator.createBeanDesc(t, t.getClass(), holder);
    }

    public static <T> boolean hasCache(Object key) {
        BeanDescFactory.initIfNeed();
        return cache.containsKey(key);
    }

    public static int getCachedSize() {
        return cache.getSize();
    }

    public static <KEY> void clear(Iterable<KEY> set) {
        BeanDescFactory.initIfNeed();
        for (KEY key : set) {
            if (!BeanDescFactory.hasCache(key)) continue;
            cache.remove(key);
        }
    }

    public static void clear() {
        cache.clear();
        initialized = false;
    }

    static {
        cache = CacheFactory.createCache(CacheType.DEFAULT, CacheSynchronization.SYNCHRONIZED);
        initialized = false;
        BeanDescFactory.init();
    }
}

