/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;

    private Splitter(Strategy strategy) {
        this(strategy, false, CharMatcher.NONE);
    }

    private Splitter(Strategy strategy, boolean omitEmptyStrings, CharMatcher trimmer) {
        this.strategy = strategy;
        this.omitEmptyStrings = omitEmptyStrings;
        this.trimmer = trimmer;
    }

    public static Splitter on(char character) {
        return Splitter.on(CharMatcher.is(character));
    }

    public static Splitter on(final CharMatcher matcher) {
        Preconditions.checkNotNull(matcher);
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                return new SplittingIterator(splitter, toSplit){

                    int delimiterStart(int start) {
                        return matcher.indexIn(this.toSplit, start);
                    }

                    int delimiterEnd(int delimiterPosition) {
                        return delimiterPosition + 1;
                    }
                };
            }
        });
    }

    public static Splitter on(final String delimiter) {
        Preconditions.checkNotNull(delimiter);
        Preconditions.checkArgument(delimiter.length() != 0, "The delimiter must not be the empty string.");
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                return new SplittingIterator(splitter, toSplit){

                    public int delimiterStart(int start) {
                        int delimeterLength = delimiter.length();
                        int last = this.toSplit.length() - delimeterLength;
                        block0: for (int p = start; p <= last; ++p) {
                            for (int i = 0; i < delimeterLength; ++i) {
                                if (this.toSplit.charAt(i + p) != delimiter.charAt(i)) continue block0;
                            }
                            return p;
                        }
                        return -1;
                    }

                    public int delimiterEnd(int delimiterPosition) {
                        return delimiterPosition + delimiter.length();
                    }
                };
            }
        });
    }

    public static Splitter on(final Pattern pattern) {
        Preconditions.checkNotNull(pattern);
        Preconditions.checkArgument(!pattern.matcher("").matches(), "The pattern must not match the empty string.");
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                final Matcher matcher = pattern.matcher(toSplit);
                return new SplittingIterator(splitter, toSplit){

                    public int delimiterStart(int start) {
                        return matcher.find(start) ? matcher.start() : -1;
                    }

                    public int delimiterEnd(int delimiterPosition) {
                        return matcher.end();
                    }
                };
            }
        });
    }

    public Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer);
    }

    public Splitter trimResults() {
        return this.trimResults(CharMatcher.WHITESPACE);
    }

    public Splitter trimResults(CharMatcher trimmer) {
        Preconditions.checkNotNull(trimmer);
        return new Splitter(this.strategy, this.omitEmptyStrings, trimmer);
    }

    public Iterable<String> split(final CharSequence sequence) {
        Preconditions.checkNotNull(sequence);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Splitter.this.strategy.iterator(Splitter.this, sequence);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractIterator<T>
    implements Iterator<T> {
        State state = State.NOT_READY;
        T next;

        private AbstractIterator() {
        }

        protected abstract T computeNext();

        protected final T endOfData() {
            this.state = State.DONE;
            return null;
        }

        @Override
        public final boolean hasNext() {
            Preconditions.checkState(this.state != State.FAILED);
            switch (this.state) {
                case DONE: {
                    return false;
                }
                case READY: {
                    return true;
                }
            }
            return this.tryToComputeNext();
        }

        boolean tryToComputeNext() {
            this.state = State.FAILED;
            this.next = this.computeNext();
            if (this.state != State.DONE) {
                this.state = State.READY;
                return true;
            }
            return false;
        }

        @Override
        public final T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.state = State.NOT_READY;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            READY,
            NOT_READY,
            DONE,
            FAILED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SplittingIterator
    extends AbstractIterator<String> {
        final CharSequence toSplit;
        final CharMatcher trimmer;
        final boolean omitEmptyStrings;
        int offset = 0;

        abstract int delimiterStart(int var1);

        abstract int delimiterEnd(int var1);

        protected SplittingIterator(Splitter splitter, CharSequence toSplit) {
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.toSplit = toSplit;
        }

        @Override
        protected String computeNext() {
            while (this.offset != -1) {
                int end;
                int start = this.offset;
                int delimiterPosition = this.delimiterStart(this.offset);
                if (delimiterPosition == -1) {
                    end = this.toSplit.length();
                    this.offset = -1;
                } else {
                    end = delimiterPosition;
                    this.offset = this.delimiterEnd(delimiterPosition);
                }
                while (start < end && this.trimmer.matches(this.toSplit.charAt(start))) {
                    ++start;
                }
                while (end > start && this.trimmer.matches(this.toSplit.charAt(end - 1))) {
                    --end;
                }
                if (this.omitEmptyStrings && start == end) continue;
                return ((Object)this.toSplit.subSequence(start, end)).toString();
            }
            return (String)this.endOfData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }
}

