/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilePart
extends PartBase {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_TRANSFER_ENCODING = "binary";
    private static final Log LOG = LogFactory.getLog(FilePart.class);
    protected static final String FILE_NAME = "; filename=";
    private static final byte[] FILE_NAME_BYTES = EncodingUtil.getAsciiBytes("; filename=");
    private PartSource source;

    public FilePart(String string, PartSource partSource, String string2, String string3) {
        super(string, string2 == null ? DEFAULT_CONTENT_TYPE : string2, string3 == null ? DEFAULT_CHARSET : string3, DEFAULT_TRANSFER_ENCODING);
        if (partSource == null) {
            throw new IllegalArgumentException("Source may not be null");
        }
        this.source = partSource;
    }

    public FilePart(String string, PartSource partSource) {
        this(string, partSource, null, null);
    }

    public FilePart(String string, File file) throws FileNotFoundException {
        this(string, new FilePartSource(file), null, null);
    }

    public FilePart(String string, File file, String string2, String string3) throws FileNotFoundException {
        this(string, new FilePartSource(file), string2, string3);
    }

    public FilePart(String string, String string2, File file) throws FileNotFoundException {
        this(string, new FilePartSource(string2, file), null, null);
    }

    public FilePart(String string, String string2, File file, String string3, String string4) throws FileNotFoundException {
        this(string, new FilePartSource(string2, file), string3, string4);
    }

    protected void sendDispositionHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendDispositionHeader(OutputStream out)");
        super.sendDispositionHeader(outputStream);
        String string = this.source.getFileName();
        if (string != null) {
            outputStream.write(FILE_NAME_BYTES);
            outputStream.write(QUOTE_BYTES);
            outputStream.write(EncodingUtil.getAsciiBytes(string));
            outputStream.write(QUOTE_BYTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendData(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendData(OutputStream out)");
        if (this.lengthOfData() == 0L) {
            LOG.debug("No data to send.");
            return;
        }
        byte[] byArray = new byte[4096];
        InputStream inputStream = this.source.createInputStream();
        try {
            int n;
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
        }
    }

    protected PartSource getSource() {
        LOG.trace("enter getSource()");
        return this.source;
    }

    protected long lengthOfData() throws IOException {
        LOG.trace("enter lengthOfData()");
        return this.source.getLength();
    }
}

