/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector.servlet;

import ch.qos.logback.classic.ClassicGlobal;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.JNDIUtil;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.impl.StaticLoggerBinder;

public class ContextDetachingSCL
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        String loggerContextName = null;
        try {
            Context ctx = JNDIUtil.getInitialContext();
            loggerContextName = JNDIUtil.lookup(ctx, ClassicGlobal.JNDI_CONTEXT_NAME);
        }
        catch (NamingException ne) {
            // empty catch block
        }
        if (loggerContextName != null) {
            System.out.println("About to detach context named " + loggerContextName);
            ContextSelector selector = StaticLoggerBinder.getSingleton().getContextSelector();
            LoggerContext context = selector.detachLoggerContext(loggerContextName);
            if (context != null) {
                Logger logger = context.getLogger("root");
                logger.warn("Stopping logger context " + loggerContextName);
                context.stop();
            } else {
                System.out.println("No context named " + loggerContextName + " was found.");
            }
        }
    }

    public void contextInitialized(ServletContextEvent arg0) {
    }
}

