/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue;

import com.google.appengine.api.labs.taskqueue.QueueConstants;
import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.UnsupportedTranslationException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskOptions
implements Serializable {
    private String taskNameValue;
    private byte[] payloadValue;
    private LinkedHashMap<String, String> headersValue;
    private Method methodValue;
    private LinkedHashMap<String, Param> paramsValue;
    private String urlValue;
    private Long countdownMillisValue;
    private Long etaMillisValue;

    private TaskOptions() {
        this.methodValue = Method.POST;
        this.headersValue = new LinkedHashMap();
        this.paramsValue = new LinkedHashMap();
    }

    public TaskOptions(TaskOptions options) {
        this.taskNameValue = options.taskNameValue;
        this.methodValue = options.methodValue;
        this.urlValue = options.urlValue;
        this.countdownMillisValue = options.countdownMillisValue;
        this.etaMillisValue = options.etaMillisValue;
        this.payload(options.getPayload());
        this.headers(options.getHeaders());
        this.params(options.getParams());
    }

    public TaskOptions taskName(String taskName) {
        if (taskName != null && taskName.length() != 0 && !QueueConstants.TASK_NAME_PATTERN.matcher(taskName).matches()) {
            throw new IllegalArgumentException("Task name does not match expression " + QueueConstants.TASK_NAME_REGEX + "; given taskname: '" + taskName + "'");
        }
        this.taskNameValue = taskName;
        return this;
    }

    String getTaskName() {
        return this.taskNameValue;
    }

    byte[] getPayload() {
        return this.payloadValue;
    }

    TaskOptions payload(byte[] payload) {
        this.payloadValue = (byte[])payload.clone();
        return this;
    }

    public TaskOptions payload(String payload, String charset) {
        try {
            return this.payload(payload.getBytes(charset), "text/plain; charset=" + charset);
        }
        catch (UnsupportedEncodingException exception) {
            throw new UnsupportedTranslationException("Unsupported charset '" + charset + "' requested.", exception);
        }
    }

    public TaskOptions payload(byte[] payload, String contentType) {
        return this.payload(payload).header("content-type", contentType);
    }

    public TaskOptions payload(String payload) {
        return this.payload(payload, "UTF-8");
    }

    LinkedHashMap<String, String> getHeaders() {
        return this.headersValue;
    }

    public TaskOptions headers(Map<String, String> headers) {
        headers = new LinkedHashMap<String, String>(headers);
        return this;
    }

    public TaskOptions header(String headerName, String value) {
        if (headerName == null || headerName.length() == 0) {
            throw new IllegalArgumentException("headerName must not be null or empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("header(name, <null>) is not allowed.");
        }
        this.headersValue.put(headerName, value);
        return this;
    }

    public TaskOptions removeHeader(String headerName) {
        if (headerName == null || headerName.length() == 0) {
            throw new IllegalArgumentException("headerName must not be null or empty.");
        }
        this.headersValue.remove(headerName);
        return this;
    }

    Method getMethod() {
        return this.methodValue;
    }

    public TaskOptions method(Method method) {
        this.methodValue = method;
        return this;
    }

    LinkedHashMap<String, Param> getParams() {
        return this.paramsValue;
    }

    TaskOptions params(Map<String, Param> params) {
        params = new LinkedHashMap<String, Param>(params);
        return this;
    }

    TaskOptions param(String paramName, Param value) {
        if (paramName == null || paramName.length() == 0) {
            throw new IllegalArgumentException("paramName must not be null or empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("param(name, <null>) is not allowed.");
        }
        this.paramsValue.put(paramName, value);
        return this;
    }

    public TaskOptions param(String paramName, String value) {
        return this.param(paramName, new StringParam(value));
    }

    public TaskOptions param(String paramName, byte[] value) {
        return this.param(paramName, new ByteArrayParam(value));
    }

    public TaskOptions removeParam(String paramName) {
        if (paramName == null || paramName.length() == 0) {
            throw new IllegalArgumentException("paramName must not be null or empty.");
        }
        this.paramsValue.remove(paramName);
        return this;
    }

    String getUrl() {
        return this.urlValue;
    }

    public TaskOptions url(String url) {
        if (url == null) {
            throw new IllegalArgumentException("null url is not allowed.");
        }
        this.urlValue = url;
        return this;
    }

    Long getCountdownMillis() {
        return this.countdownMillisValue;
    }

    public TaskOptions countdownMillis(long countdownMillis) {
        this.countdownMillisValue = countdownMillis;
        return this;
    }

    Long getEtaMillis() {
        return this.etaMillisValue;
    }

    public TaskOptions etaMillis(long etaMillis) {
        this.etaMillisValue = etaMillis;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        public static TaskOptions taskName(String taskName) {
            return Builder.withDefaults().taskName(taskName);
        }

        static TaskOptions payload(byte[] payload) {
            return Builder.withDefaults().payload(payload);
        }

        public static TaskOptions payload(String payload, String charset) {
            return Builder.withDefaults().payload(payload, charset);
        }

        public static TaskOptions payload(String payload) {
            return Builder.withDefaults().payload(payload);
        }

        public static TaskOptions headers(Map<String, String> headers) {
            return Builder.withDefaults().headers(headers);
        }

        public static TaskOptions header(String headerName, String value) {
            return Builder.withDefaults().header(headerName, value);
        }

        public static TaskOptions method(Method method) {
            return Builder.withDefaults().method(method);
        }

        static TaskOptions params(Map<String, Param> params) {
            return Builder.withDefaults().params(params);
        }

        public static TaskOptions param(String paramName, String value) {
            return Builder.withDefaults().param(paramName, value);
        }

        public static TaskOptions param(String paramName, byte[] value) {
            return Builder.withDefaults().param(paramName, value);
        }

        public static TaskOptions url(String url) {
            return Builder.withDefaults().url(url);
        }

        public static TaskOptions countdownMillis(long countdownMillis) {
            return Builder.withDefaults().countdownMillis(countdownMillis);
        }

        public static TaskOptions etaMillis(long etaMillis) {
            return Builder.withDefaults().etaMillis(etaMillis);
        }

        public static TaskOptions withDefaults() {
            return new TaskOptions();
        }

        private Builder() {
        }
    }

    static class ByteArrayParam
    implements Param {
        final byte[] bytes;

        ByteArrayParam(byte[] bytes) {
            this.bytes = bytes;
        }

        public String getAsURLEncoded() throws UnsupportedEncodingException {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.bytes.length; ++i) {
                result.append("%");
                char character = Character.toUpperCase(Character.forDigit(this.bytes[i] >> 4 & 0xF, 16));
                result.append(character);
                character = Character.toUpperCase(Character.forDigit(this.bytes[i] & 0xF, 16));
                result.append(character);
            }
            return result.toString();
        }
    }

    static class StringParam
    implements Param {
        final String string;

        StringParam(String string) {
            this.string = string;
        }

        public String getAsURLEncoded() throws UnsupportedEncodingException {
            return URLEncoder.encode(this.string, "UTF-8");
        }
    }

    static interface Param {
        public String getAsURLEncoded() throws UnsupportedEncodingException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        DELETE(TaskQueuePb.TaskQueueAddRequest.RequestMethod.DELETE, false),
        GET(TaskQueuePb.TaskQueueAddRequest.RequestMethod.GET, false),
        HEAD(TaskQueuePb.TaskQueueAddRequest.RequestMethod.HEAD, false),
        POST(TaskQueuePb.TaskQueueAddRequest.RequestMethod.POST, true),
        PUT(TaskQueuePb.TaskQueueAddRequest.RequestMethod.PUT, true);

        private TaskQueuePb.TaskQueueAddRequest.RequestMethod pbMethod;
        private boolean isBodyMethod;

        private Method(TaskQueuePb.TaskQueueAddRequest.RequestMethod pbMethod, boolean isBodyMethod) {
            this.pbMethod = pbMethod;
            this.isBodyMethod = isBodyMethod;
        }

        TaskQueuePb.TaskQueueAddRequest.RequestMethod getPbMethod() {
            return this.pbMethod;
        }

        boolean supportsBody() {
            return this.isBodyMethod;
        }
    }
}

