/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.util.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.PatternUtil;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.util.PathUtil;
import org.t2framework.t2.util.UrlTemplate;

public class UrlTemplateImpl
implements UrlTemplate {
    protected final String templatePath;
    protected List<Pattern> patterns = CollectionsUtil.newArrayList();
    protected List<String> expressionNames = CollectionsUtil.newArrayList();

    public UrlTemplateImpl(String templatePath) {
        this.templatePath = templatePath;
        this.init(templatePath);
    }

    protected void init(String templatePath) {
        boolean startSlash = PathUtil.startsWithSlash(templatePath);
        String s = this.escapePatternString(templatePath);
        Matcher matcher = this.createMatcher(s);
        while (matcher.find()) {
            String name = matcher.group(2);
            String expression = matcher.group(1);
            String[] names = name.split(",", 2);
            if (names.length == 1) {
                s = StringUtil.replace((String)s, (String)expression, (String)"([a-zA-Z0-9!@%\\|\\-\\_\\^\\$\\.\\*\\+'\\(\\)\\,]+)");
                this.addExpressionName(name);
                continue;
            }
            for (String str : names) {
                this.addExpressionName(str);
            }
            s = StringUtil.replace((String)s, (String)expression, (String)"([a-zA-Z0-9!@%\\|\\-\\_\\^\\$\\.\\*\\+'\\(\\)\\,]+)");
        }
        this.patterns.add(PatternUtil.getPattern((String)s));
        if (startSlash) {
            this.patterns.add(PatternUtil.getPattern((String)s.substring(1)));
        } else {
            this.patterns.add(PatternUtil.getPattern((String)("/" + s)));
        }
    }

    protected void addExpressionName(String name) {
        if (!this.expressionNames.contains(name)) {
            this.expressionNames.add(name);
        }
    }

    @Override
    public List<Pattern> getUrlPattern() {
        return this.patterns;
    }

    @Override
    public Map<String, String> parseUrl(String urlPath) {
        String[] pathStrs;
        String[] templateStrs;
        Assertion.notNull((Object)urlPath);
        if (!this.match(urlPath)) {
            return null;
        }
        String path = urlPath;
        if (urlPath.indexOf("/") != 0) {
            path = "/" + urlPath;
        }
        if ((templateStrs = StringUtil.split((String)this.templatePath, (String)"/")).length != (pathStrs = StringUtil.split((String)path, (String)"/")).length) {
            throw new IllegalStateException("should be same depth.");
        }
        HashMap retMap = CollectionsUtil.newHashMap();
        for (int i = 0; i < templateStrs.length; ++i) {
            String key = templateStrs[i];
            int startIndex = key.indexOf("{");
            int lastIndex = key.lastIndexOf("}");
            if (startIndex < 0 || lastIndex <= 0) continue;
            String value = pathStrs[i];
            if (startIndex == 0 && lastIndex == key.length() - 1) {
                retMap.put(key, value);
                continue;
            }
            String choppedKey = key.substring(startIndex, lastIndex + 1);
            if (startIndex != 0) {
                value = value.substring(startIndex);
            }
            if (lastIndex < key.length() - 1) {
                String postfix = key.substring(lastIndex + 1);
                int postfixPos = value.lastIndexOf(postfix);
                value = postfixPos > 0 ? value.substring(0, value.length() - postfixPos + 1) : value;
            }
            retMap.put(choppedKey, value);
        }
        return retMap;
    }

    @Override
    public boolean match(String urlPath) {
        Assertion.notNull((Object)urlPath);
        for (Pattern p : this.patterns) {
            if (!p.matcher(urlPath).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String bindByName(Map<String, String> parameters) {
        Assertion.notNull(parameters);
        String s = this.templatePath;
        Matcher matcher = this.createMatcher(s);
        while (matcher.find()) {
            String name = matcher.group(2);
            String[] names = name.split(",", 2);
            if (names.length == 1) {
                s = StringUtil.replace((String)s, (String)matcher.group(1), (String)parameters.get(name));
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < names.length; ++i) {
                String value = parameters.get(names[i]);
                builder.append(value);
                builder.append(",");
            }
            builder.setLength(builder.length() - 1);
            s = StringUtil.replace((String)s, (String)matcher.group(1), (String)builder.toString());
        }
        return s;
    }

    @Override
    public String bindByPosition(String ... values) {
        String s = this.templatePath;
        Matcher matcher = this.createMatcher(s);
        if (matcher.groupCount() - 1 > values.length) {
            throw new IllegalStateException();
        }
        int index = 0;
        while (matcher.find()) {
            String name = matcher.group(2);
            String[] names = name.split(",", 2);
            if (names.length == 1) {
                s = StringUtil.replace((String)s, (String)matcher.group(1), (String)values[index]);
            } else {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < names.length; ++i) {
                    builder.append(values[i]);
                    builder.append(",");
                }
                builder.setLength(builder.length() - 1);
                s = StringUtil.replace((String)s, (String)matcher.group(1), (String)builder.toString());
            }
            ++index;
        }
        return s;
    }

    @Override
    public List<String> getExpressionNames() {
        return this.expressionNames;
    }

    protected Matcher createMatcher(String s) {
        return TEMPLATE_PATTERN.matcher(s);
    }

    protected String escapePatternString(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if ("\\[].^$?*+()|,:<>=".indexOf(ch) >= 0) {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public String getTemplatePath() {
        return this.templatePath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expressionNames == null ? 0 : ((Object)this.expressionNames).hashCode());
        result = 31 * result + (this.patterns == null ? 0 : ((Object)this.patterns).hashCode());
        result = 31 * result + (this.templatePath == null ? 0 : this.templatePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UrlTemplateImpl other = (UrlTemplateImpl)obj;
        if (this.expressionNames == null ? other.expressionNames != null : !((Object)this.expressionNames).equals(other.expressionNames)) {
            return false;
        }
        if (this.patterns == null ? other.patterns != null : !((Object)this.patterns).equals(other.patterns)) {
            return false;
        }
        return !(this.templatePath == null ? other.templatePath != null : !this.templatePath.equals(other.templatePath));
    }
}

