/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.plugin;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.adapter.ContainerAdapter;
import org.t2framework.t2.contexts.WebApplication;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.plugin.Plugin;
import org.t2framework.t2.spi.Navigation;

public abstract class AbstractPlugin
implements Plugin {
    protected ContainerAdapter<?> containerAdapter;

    @Override
    public void initialize(ServletContext servletContext, WebApplication webApplication) {
    }

    @Override
    public void beginRequestProcessing(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public HttpServletRequest createRequest(HttpServletRequest request, HttpServletResponse response) {
        return request;
    }

    @Override
    public HttpServletResponse createResponse(HttpServletRequest request, HttpServletResponse response) {
        return response;
    }

    @Override
    public Navigation componentCreated(WebContext context, Object page) {
        return this.getPluginDefaultNavigation();
    }

    @Override
    public Navigation beforeActionInvoke(ActionContext actionContext, MethodDesc targetMethod, Object page, Object[] args) {
        return this.getPluginDefaultNavigation();
    }

    @Override
    public Navigation afterActionInvoke(ActionContext actionContext, MethodDesc targetMethod, Object page, Object[] args) {
        return this.getPluginDefaultNavigation();
    }

    @Override
    public void beforeNavigation(WebContext context) {
    }

    @Override
    public void afterNavigation(WebContext context) {
    }

    @Override
    public void endRequestProcessing(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public void destroy(ServletContext servletContext, WebApplication webApplication) {
    }

    @Override
    public void setContainerAdapter(ContainerAdapter<?> containerAdapter) {
        this.containerAdapter = (ContainerAdapter)Assertion.notNull(containerAdapter);
    }

    protected ContainerAdapter<?> getContainerAdapter() {
        return this.containerAdapter;
    }

    public <C> C getAdapter(Class<C> clazz) {
        Assertion.notNull(clazz);
        if (ContainerAdapter.class.isAssignableFrom(clazz)) {
            return (C)this.containerAdapter;
        }
        return null;
    }

    protected Navigation getPluginDefaultNavigation() {
        return PluginDefaultNavigation.INSTANCE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.containerAdapter == null ? 0 : this.containerAdapter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPlugin other = (AbstractPlugin)obj;
        return !(this.containerAdapter == null ? other.containerAdapter != null : !this.containerAdapter.equals(other.containerAdapter));
    }

    public static class PluginDefaultNavigation
    implements Navigation {
        public static final PluginDefaultNavigation INSTANCE = new PluginDefaultNavigation();

        @Override
        public void execute(WebContext context) throws Exception {
        }
    }
}

