/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.filter;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.util.Logger;
import org.t2framework.t2.action.ActionInvoker;
import org.t2framework.t2.action.impl.ActionInvokerImpl;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.WebApplication;
import org.t2framework.t2.contexts.WebConfiguration;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.contexts.impl.WebConfigurationImpl;
import org.t2framework.t2.navigation.PassThrough;
import org.t2framework.t2.plugin.PluginProcessor;
import org.t2framework.t2.plugin.impl.PluginProcessorImpl;
import org.t2framework.t2.spi.Navigation;

public class T2Filter
implements Filter {
    protected Logger log = Logger.getLogger(T2Filter.class);
    protected WebConfiguration webConfig;
    protected PluginProcessor processor;

    public void init(FilterConfig config) throws ServletException {
        try {
            this.webConfig = new WebConfigurationImpl(config);
            this.webConfig.initialize();
            this.processor = new PluginProcessorImpl(this.webConfig.getContainerAdapter());
            this.processor.invokeInit(this.webConfig.getServletContext(), this.webConfig.getWebApplication());
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        this.webConfig.setupRequestAndResponse(req, res);
        this.processor.beginRequest(req, res);
        WebContext context = null;
        try {
            req = this.processor.createRequest(req, res);
            res = this.processor.createResponse(req, res);
            WebApplication webapp = this.webConfig.getWebApplication();
            FilterConfig filterConfig = this.webConfig.getFilterConfig();
            context = webapp.createContext(req, res, chain, filterConfig);
            if (this.isExcludeRequest(req)) {
                this.handleOtherRequest(context);
                return;
            }
            Map<String, PageDesc> pageDescMap = webapp.createPageDescMap();
            ActionInvokerImpl invoker = new ActionInvokerImpl(context, pageDescMap, this.webConfig.getContainerAdapter(), this.webConfig.getResolverCreator(), this.processor);
            if (!invoker.match()) {
                this.handleOtherRequest(context);
                return;
            }
            this.handleNavigation(invoker, this.processor, context);
        }
        catch (Throwable t) {
            this.webConfig.getGlobalExceptionHandler().handleException(t, context);
        }
        finally {
            try {
                this.processor.endRequest(req, res);
            }
            finally {
                WebContext.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNavigation(ActionInvoker invoker, PluginProcessor processor, WebContext context) throws Throwable {
        Navigation navigation = invoker.invoke();
        try {
            processor.beforeNavigation(context);
            navigation.execute(context);
        }
        finally {
            processor.afterNavigation(context);
        }
    }

    public void destroy() {
        this.processor.destroy(this.webConfig.getServletContext(), this.webConfig.getWebApplication());
        this.webConfig.destroy();
        this.webConfig = null;
        this.processor = null;
    }

    protected boolean isExcludeRequest(HttpServletRequest req) {
        String[] excludes;
        String uri = req.getRequestURI();
        for (String exclude : excludes = this.webConfig.getExcludeResources()) {
            if (!uri.endsWith(exclude)) continue;
            return true;
        }
        return false;
    }

    protected void handleOtherRequest(WebContext context) throws Exception {
        PassThrough.pass().execute(context);
    }
}

