/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.filter;

import javax.servlet.FilterConfig;
import org.t2framework.commons.Constants;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.T2ConfigurationKey;
import org.t2framework.t2.exception.NoRootPackageDefinedException;

public class T2ConfigurationUtil {
    public static final boolean EAGER_LOAD_DEFAULT_VALUE = false;

    public static String getAdapterClass(FilterConfig config) {
        String adapterClass = config.getInitParameter("t2.container.adapter");
        if (StringUtil.isEmpty((String)adapterClass)) {
            adapterClass = T2ConfigurationKey.DEFAULT_ADAPTER_CLASS;
        }
        return adapterClass;
    }

    public static String getEncoding(FilterConfig config) {
        String encoding = config.getServletContext().getInitParameter("t2.encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public static String getUserConfig(FilterConfig config) {
        return config.getInitParameter("t2.config");
    }

    public static String[] getRootPackages(FilterConfig config) {
        String roots = config.getInitParameter("t2.rootpackage");
        if (StringUtil.isEmpty((String)roots)) {
            throw new NoRootPackageDefinedException();
        }
        return T2ConfigurationUtil.split(roots);
    }

    public static String[] getExcludeResources(FilterConfig config) {
        String s = config.getInitParameter("t2.exclude-resources");
        if (StringUtil.isEmpty((String)s)) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        return T2ConfigurationUtil.split(s);
    }

    public static boolean getEagerLoad(FilterConfig config) {
        String eagerLoad = config.getInitParameter("t2.eagerload");
        if (StringUtil.isEmpty((String)eagerLoad)) {
            return false;
        }
        return Boolean.valueOf(eagerLoad);
    }

    protected static String[] split(String s) {
        return StringUtil.split((String)s, (String)", ");
    }
}

