/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.filter;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.ServletUtil;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.contexts.MultiPart;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.UploadFile;
import org.t2framework.t2.contexts.impl.MultiPartImpl;
import org.t2framework.t2.contexts.impl.UploadFileImpl;
import org.t2framework.t2.filter.T2ConfigurationUtil;

public class MultiPartRequestFilter
implements Filter {
    private static final Logger log = Logger.getLogger(MultiPartRequestWrapper.class);
    public static final int DEFAULT_MAX_SIZE = 0x6400000;
    public static final int DEFAULT_MAX_FILE_SIZE = 0x6400000;
    public static final int DEFAULT_THREASHOLD_SIZE = 102400;
    protected static int maxSize;
    protected static int maxFileSize;
    protected static int thresholdSize;
    protected static String repositoryPath;
    protected static String encoding;

    public void init(FilterConfig filterConfig) throws ServletException {
        maxSize = ServletUtil.getSizeParameter((FilterConfig)filterConfig, (String)"uploadMaxSize", (int)0x6400000);
        maxFileSize = ServletUtil.getSizeParameter((FilterConfig)filterConfig, (String)"uploadMaxFileSize", (int)0x6400000);
        thresholdSize = ServletUtil.getSizeParameter((FilterConfig)filterConfig, (String)"uploadThresholdSize", (int)102400);
        repositoryPath = filterConfig.getInitParameter("uploadRepositoryPath");
        encoding = T2ConfigurationUtil.getEncoding(filterConfig);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            this.setupEncoding(request);
            request = this.createHttpServletRequestWrapper(request, maxSize, maxFileSize, thresholdSize, repositoryPath);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected HttpServletRequest createHttpServletRequestWrapper(HttpServletRequest request, int maxSize, int maxFileSize, int thresholdSize, String repositoryPath) {
        return new MultiPartRequestWrapper(request, maxSize, maxFileSize, thresholdSize, repositoryPath);
    }

    public void destroy() {
    }

    protected void setupEncoding(HttpServletRequest request) throws UnsupportedEncodingException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(encoding);
        }
    }

    protected int getSizeParameter(FilterConfig filterConfig, String parameterName, int defaultValue) {
        String param = filterConfig.getInitParameter(parameterName);
        if (StringUtil.isEmpty((String)param)) {
            return defaultValue;
        }
        param = param.toLowerCase();
        int factor = 1;
        String number = param;
        if (StringUtil.endsWithIgnoreCase((String)param, (String)"g")) {
            factor = 0x40000000;
            number = param.substring(0, param.length() - 1);
        } else if (StringUtil.endsWithIgnoreCase((String)param, (String)"m")) {
            factor = 0x100000;
            number = param.substring(0, param.length() - 1);
        } else if (StringUtil.endsWithIgnoreCase((String)param, (String)"k")) {
            factor = 1024;
            number = param.substring(0, param.length() - 1);
        }
        return Integer.parseInt(number) * factor;
    }

    static {
        repositoryPath = null;
    }

    public static class MultiPartRequestWrapper
    extends HttpServletRequestWrapper {
        private final HttpServletRequest request;
        private Map<String, String[]> paramMap;

        public MultiPartRequestWrapper(HttpServletRequest request, int sizeMax, int fileSizeMax, int sizeThreshold, String repositoryPath) {
            super(request);
            this.request = (HttpServletRequest)Assertion.notNull((Object)request);
            this.setupRequestParamMap(request, sizeMax, fileSizeMax, sizeThreshold, repositoryPath);
        }

        protected void setupRequestParamMap(HttpServletRequest request, int sizeMax, int fileSizeMax, int sizeThreshold, String repositoryPath) {
            String enc = request.getCharacterEncoding();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(sizeThreshold);
            if (!StringUtil.isEmpty((String)repositoryPath)) {
                factory.setRepository(new File(repositoryPath));
            }
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setHeaderEncoding(enc);
            upload.setFileSizeMax((long)fileSizeMax);
            upload.setSizeMax((long)sizeMax);
            try {
                this.paramMap = this.prepareParameters(upload.parseRequest(request), encoding);
            }
            catch (FileUploadException e) {
                this.logUploadError(e, request);
                this.paramMap = request.getParameterMap();
            }
        }

        protected void logUploadError(FileUploadException e, HttpServletRequest request) {
            if (e instanceof FileUploadBase.InvalidContentTypeException) {
                log.log("WTDT0007", (Throwable)e, new Object[]{request.getContentType()});
            } else if (e instanceof FileUploadBase.IOFileUploadException) {
                log.log("WTDT0008", (Throwable)e, new Object[]{e.getMessage()});
            } else if (e instanceof FileUploadBase.FileSizeLimitExceededException) {
                log.log("WTDT0009", (Throwable)e, new Object[]{maxSize});
            } else if (e instanceof FileUploadBase.SizeLimitExceededException) {
                log.log("WTDT0010", (Throwable)e, new Object[]{request.getContentLength(), maxSize});
            } else {
                log.log("WTDT0011", (Throwable)e, new Object[]{e.toString()});
            }
        }

        public String getParameter(String name) {
            String value = (String)this.getFirst(this.paramMap.get(name));
            if (value == null) {
                value = super.getParameter(name);
            }
            return value;
        }

        public Map getParameterMap() {
            return this.paramMap;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.paramMap.keySet());
        }

        public String[] getParameterValues(String name) {
            return this.paramMap.get(name);
        }

        protected Map<String, String[]> prepareParameters(List<FileItem> fileItemList, String encoding) {
            Map paramMap = CollectionsUtil.newHashMap((Map)this.request.getParameterMap());
            MultiPart multiPart = this.createMultiPart();
            for (FileItem fileItem : fileItemList) {
                Object value;
                String fieldName = fileItem.getFieldName();
                if (fileItem.isFormField()) {
                    try {
                        value = fileItem.getString(encoding);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException();
                    }
                    paramMap.put(fieldName, this.add((Object[])paramMap.get(fieldName), value, String.class));
                    continue;
                }
                value = this.createUploadFile(fileItem);
                multiPart.addUploadFile(fieldName, (UploadFile)value);
            }
            this.storeMultipart(multiPart);
            return Collections.unmodifiableMap(paramMap);
        }

        protected void storeMultipart(MultiPart multiPart) {
            this.request.setAttribute(Request.MULTIPART_ATTRIBUTE_KEY, (Object)multiPart);
        }

        protected MultiPart createMultiPart() {
            return new MultiPartImpl();
        }

        protected UploadFile createUploadFile(FileItem fileItem) {
            return new UploadFileImpl(fileItem);
        }

        protected <T> T[] add(T[] objs, T value, Class<T> clazz) {
            Object[] newObjs;
            if (objs == null) {
                newObjs = (Object[])Array.newInstance(clazz, 1);
                newObjs[0] = value;
            } else {
                newObjs = (Object[])Array.newInstance(objs.getClass().getComponentType(), objs.length + 1);
                System.arraycopy(objs, 0, newObjs, 0, objs.length);
                newObjs[objs.length] = value;
            }
            return newObjs;
        }

        protected Object getFirst(Object obj) {
            Object[] objs = (Object[])obj;
            if (objs == null || objs.length == 0) {
                return null;
            }
            return objs[0];
        }
    }
}

