/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.ContentTypeUtil;
import org.t2framework.commons.util.ServletUtil;
import org.t2framework.t2.contexts.Response;

public class ResponseImpl
implements Response {
    protected final HttpServletResponse response;
    protected String contentType;

    public ResponseImpl(HttpServletResponse response) {
        this.response = (HttpServletResponse)Assertion.notNull((Object)response);
        this.contentType = response.getContentType();
    }

    @Override
    public String getCharacterEncoding() {
        String type = this.getContentType();
        String encoding = ContentTypeUtil.getEncodingFromContentType((String)type);
        if (encoding != null) {
            return encoding;
        }
        return this.response.getCharacterEncoding();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() throws IORuntimeException {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = (String)Assertion.notNull((Object)contentType);
        this.response.setContentType(contentType);
    }

    @Override
    public HttpServletResponse getNativeResource() {
        return this.response;
    }

    @Override
    public void redirect(String path) {
        Assertion.notNull((Object)path);
        ServletUtil.redirect((HttpServletResponse)this.response, (String)path);
    }

    @Override
    public void setHeader(String key, String value) {
        Assertion.notNull((Object)key);
        Assertion.notNull((Object)value);
        this.getNativeResource().setHeader(key, value);
    }

    @Override
    public void setNoCache() {
        this.response.setHeader("Pragma", "No-cache");
        this.response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
        this.response.setDateHeader("Expires", 1L);
    }

    @Override
    public void writeAndFlush(String s) throws IOException {
        PrintWriter writer = this.getWriter();
        writer.write(s);
        writer.flush();
    }

    @Override
    public void write(String s) throws IOException {
        PrintWriter writer = this.getWriter();
        writer.write(s);
    }

    protected PrintWriter getWriter() throws IOException {
        return this.getNativeResource().getWriter();
    }

    @Override
    public void flush() throws IOException {
        PrintWriter writer = this.getWriter();
        writer.flush();
    }
}

