/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.ServletUtil;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.commons.util.URLUtil;
import org.t2framework.t2.contexts.HttpMethod;
import org.t2framework.t2.contexts.MultiPart;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.Session;

public class RequestImpl
implements Request {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Session session;
    protected boolean amfEnabled;
    protected Object lock = new Object();

    public RequestImpl(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, false);
    }

    public RequestImpl(HttpServletRequest request, HttpServletResponse response, boolean amfEnabled) {
        this.request = (HttpServletRequest)Assertion.notNull((Object)request);
        this.response = (HttpServletResponse)Assertion.notNull((Object)response);
        this.amfEnabled = amfEnabled;
        this.init();
    }

    protected void init() {
    }

    @Override
    public String getContextPath() {
        return this.getNativeResource().getContextPath();
    }

    @Override
    public String getEncoding() {
        return this.getNativeResource().getCharacterEncoding();
    }

    @Override
    public Locale getLocale() {
        return this.getNativeResource().getLocale();
    }

    @Override
    public HttpMethod getMethod() {
        String method = this.getNativeResource().getMethod();
        return HttpMethod.getMethodType(method);
    }

    @Override
    public String getPath() {
        return this.getNativeResource().getPathInfo();
    }

    @Override
    public List<String> getAttributeNames() {
        List ret = CollectionsUtil.newArrayList();
        Enumeration e = this.getNativeResource().getAttributeNames();
        while (e.hasMoreElements()) {
            ret.add(e.nextElement());
        }
        return ret;
    }

    @Override
    public Map<String, Object> getAttributesAsMap() {
        HashMap ret = CollectionsUtil.newHashMap();
        Enumeration e = this.getNativeResource().getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = this.getNativeResource().getAttribute(key);
            ret.put(key, value);
        }
        return ret;
    }

    @Override
    public <V> V getAttribute(String key) {
        return (V)this.getNativeResource().getAttribute(key);
    }

    @Override
    public synchronized <V> V removeAttribute(String key) {
        V ret = this.getAttribute(key);
        this.getNativeResource().removeAttribute(key);
        return ret;
    }

    @Override
    public synchronized <V> void setAttribute(String key, V value) {
        Assertion.notNull((Object)key);
        this.getNativeResource().setAttribute(key, value);
    }

    @Override
    public List<String> getParameterNames() {
        List list = CollectionsUtil.newArrayList();
        Map parameterMap = this.getNativeResource().getParameterMap();
        for (String s : parameterMap.keySet()) {
            list.add(s);
        }
        return list;
    }

    @Override
    public Map<String, String[]> getParametersAsMap() {
        return this.request.getParameterMap();
    }

    @Override
    public String[] getParameters(String key) {
        return this.getNativeResource().getParameterValues(key);
    }

    @Override
    public HttpServletRequest getNativeResource() {
        return this.request;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = (Session)Assertion.notNull((Object)session);
    }

    @Override
    public void forward(String path) {
        RequestDispatcher dispatcher = this.getNativeResource().getRequestDispatcher(path);
        ServletUtil.forward((RequestDispatcher)dispatcher, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
    }

    @Override
    public boolean isForwarded() {
        return this.request.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    @Override
    public String getParameter(String key) {
        return this.getNativeResource().getParameter(key);
    }

    @Override
    public boolean hasMultipleParameters(String key) {
        String[] values = this.getNativeResource().getParameterValues(key);
        return values != null && values.length > 1;
    }

    @Override
    public int getContentLength() {
        return this.getNativeResource().getContentLength();
    }

    @Override
    public InputStream getInputStream() throws IORuntimeException {
        try {
            return this.getNativeResource().getInputStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public boolean isMultipartType() {
        return ServletUtil.isMultipart((HttpServletRequest)this.getNativeResource());
    }

    @Override
    public boolean isAjaxRequest() {
        HttpServletRequest req = this.getNativeResource();
        String value = req.getHeader("X-Requested-With");
        if (StringUtil.isEmpty((String)value)) {
            return false;
        }
        return "xmlhttprequest".equalsIgnoreCase(value.toLowerCase());
    }

    @Override
    public boolean isAmfRequest() {
        return false;
    }

    @Override
    public MultiPart getMultiPart() {
        return (MultiPart)this.getNativeResource().getAttribute(Request.MULTIPART_ATTRIBUTE_KEY);
    }

    @Override
    public Map<String, Object> getHeaders() {
        HashMap headers = CollectionsUtil.newHashMap();
        Enumeration e = this.getNativeResource().getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ArrayList<String> list = new ArrayList<String>();
            Enumeration values = this.getNativeResource().getHeaders(key);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                list.add(value);
            }
            int size = list.size();
            if (size == 0) continue;
            if (1 < size) {
                headers.put(key, list.toArray(new String[size]));
                continue;
            }
            headers.put(key, list.get(0));
        }
        return headers;
    }

    @Override
    public String decode(String value) {
        return URLUtil.decode((String)value, (String)this.getEncoding());
    }
}

