/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.appengine.DatastoreAbstractListStoreSpecialization;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.DatastoreRelationFieldManager;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.KeyRegistry;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.mapped.scostore.FKListStore;
import org.datanucleus.store.mapped.scostore.FKListStoreSpecialization;
import org.datanucleus.util.Localiser;

class DatastoreFKListStoreSpecialization
extends DatastoreAbstractListStoreSpecialization
implements FKListStoreSpecialization {
    private final ThreadLocal<Boolean> removing = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    DatastoreFKListStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, DatastoreManager storeMgr) {
        super(localiser, clr, storeMgr);
    }

    public Object set(StateManager ownerSm, int index, Object element, boolean allowDependentField, ElementContainerStore ecs, Object obj) {
        ObjectManager om;
        StateManager childSm;
        Entity childEntity;
        DatastorePersistenceHandler handler = this.storeMgr.getPersistenceHandler();
        JavaTypeMapping orderMapping = ecs.getOrderMapping();
        if (orderMapping != null && (childEntity = (Entity)(childSm = (om = ownerSm.getObjectManager()).findStateManager(element)).getAssociatedValue(DatastorePersistenceHandler.ENTITY_WRITE_DELAYED)) != null) {
            childSm.setAssociatedValue(DatastorePersistenceHandler.ENTITY_WRITE_DELAYED, null);
            childSm.setAssociatedValue((Object)ecs.getOrderMapping(), (Object)index);
            handler.insertObject(childSm);
        }
        if (ecs.getOwnerMemberMetaData().getCollection().isDependentElement() && allowDependentField && obj != null) {
            ownerSm.getObjectManager().deleteObjectInternal(obj);
        }
        return obj;
    }

    public boolean updateElementFk(StateManager sm, Object element, Object parent, int index, ObjectManager om, ElementContainerStore ecs) {
        DatastoreRelationFieldManager.checkForParentSwitch(element, sm);
        if (ecs.getOrderMapping() == null) {
            return false;
        }
        StateManager elementSm = om.findStateManager(element);
        DatastorePersistenceHandler handler = this.storeMgr.getPersistenceHandler();
        Entity entity = (Entity)elementSm.getAssociatedValue(DatastorePersistenceHandler.ENTITY_WRITE_DELAYED);
        if (entity != null) {
            elementSm.setAssociatedValue(DatastorePersistenceHandler.ENTITY_WRITE_DELAYED, null);
            elementSm.setAssociatedValue((Object)ecs.getOrderMapping(), (Object)index);
            if (entity.getParent() == null) {
                StateManager parentSm = om.findStateManager(parent);
                Key parentKey = EntityUtils.getPrimaryKeyAsKey(om.getApiAdapter(), parentSm);
                KeyRegistry.getKeyRegistry(om).registerKey(element, parentKey);
            }
            handler.insertObject(elementSm);
        }
        return true;
    }

    public void clearWithoutDelete(ObjectManager om, StateManager ownerSM, ElementContainerStore ecs) {
        throw new UnsupportedOperationException("Non-owned relationships are not currently supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAt(StateManager sm, int index, int size, boolean nullify, FKListStore fkListStore) {
        if (this.removing.get().booleanValue()) {
            return;
        }
        if (nullify) {
            throw new UnsupportedOperationException("Non-owned relationships are not currently supported.");
        }
        ObjectManager om = sm.getObjectManager();
        Object element = fkListStore.get(sm, index);
        StateManager elementStateManager = om.findStateManager(element);
        DatastorePersistenceHandler handler = this.storeMgr.getPersistenceHandler();
        this.removing.set(true);
        try {
            handler.deleteObject(elementStateManager);
        }
        finally {
            this.removing.set(false);
        }
        if (fkListStore.getOrderMapping() != null) {
            JavaTypeMapping orderMapping = fkListStore.getOrderMapping();
            DatastoreService service = DatastoreServiceFactoryInternal.getDatastoreService();
            AbstractClassMetaData acmd = fkListStore.getEmd();
            String kind = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
            Query q = new Query(kind);
            Object id = om.getApiAdapter().getTargetKeyForSingleFieldIdentity(sm.getInternalObjectId());
            Key key = id instanceof Key ? (Key)id : KeyFactory.stringToKey((String)((String)id));
            q.setAncestor(key);
            Entity entity = new Entity(kind);
            orderMapping.setObject(om, (Object)entity, new int[]{1}, (Object)index);
            String indexProp = (String)entity.getProperties().keySet().iterator().next();
            q.addFilter(indexProp, Query.FilterOperator.GREATER_THAN, (Object)index);
            for (Entity shiftMe : service.prepare(service.getCurrentTransaction(null), q).asIterable()) {
                Long pos = (Long)shiftMe.getProperty(indexProp);
                shiftMe.setProperty(indexProp, (Object)(pos - 1L));
                handler.put(om, shiftMe);
            }
        }
    }
}

