/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.store.appengine.DatastoreAbstractListStoreSpecialization;
import org.datanucleus.store.appengine.DatastoreFKListStoreSpecialization;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.mapped.scostore.FKListStore;
import org.datanucleus.store.mapped.scostore.FKListStoreSpecialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreFKListStore
extends FKListStore {
    public DatastoreFKListStore(AbstractMemberMetaData fmd, DatastoreManager storeMgr, ClassLoaderResolver clr) {
        super(fmd, (MappedStoreManager)storeMgr, clr, (FKListStoreSpecialization)new DatastoreFKListStoreSpecialization(LOCALISER, clr, storeMgr));
    }

    protected ListIterator listIterator(StateManager ownerSM, int startIdx, int endIdx) {
        ObjectManager om = ownerSM.getObjectManager();
        ApiAdapter apiAdapter = om.getApiAdapter();
        Key parentKey = EntityUtils.getPrimaryKeyAsKey(apiAdapter, ownerSM);
        return ((DatastoreAbstractListStoreSpecialization)this.specialization).getChildren(parentKey, this.getFilterPredicates(startIdx, endIdx), this.getSortPredicates(), (ElementContainerStore)this, om).listIterator();
    }

    private List<Query.FilterPredicate> getFilterPredicates(int startIdx, int endIdx) {
        ArrayList<Object> filterPredicates = Utils.newArrayList(new Object[0]);
        if (this.indexedList) {
            String indexProperty = this.getIndexPropertyName();
            if (startIdx >= 0 && endIdx == startIdx) {
                Query.FilterPredicate filterPred = new Query.FilterPredicate(indexProperty, Query.FilterOperator.EQUAL, (Object)startIdx);
                filterPredicates.add(filterPred);
            } else if (startIdx != -1 || endIdx != -1) {
                Query.FilterPredicate filterPred;
                if (startIdx >= 0) {
                    filterPred = new Query.FilterPredicate(indexProperty, Query.FilterOperator.GREATER_THAN_OR_EQUAL, (Object)startIdx);
                    filterPredicates.add(filterPred);
                }
                if (endIdx >= 0) {
                    filterPred = new Query.FilterPredicate(indexProperty, Query.FilterOperator.LESS_THAN, (Object)endIdx);
                    filterPredicates.add(filterPred);
                }
            }
        }
        return filterPredicates;
    }

    private String getIndexPropertyName() {
        String propertyName;
        if (this.orderMapping.getMemberMetaData() == null) {
            propertyName = this.orderMapping.getDataStoreMappings()[0].getDatastoreField().getIdentifier().getIdentifierName();
        } else {
            propertyName = this.orderMapping.getMemberMetaData().getName();
            AbstractMemberMetaData ammd = this.orderMapping.getMemberMetaData();
            if (ammd.getColumn() != null) {
                propertyName = ammd.getColumn();
            } else if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length == 1) {
                propertyName = ammd.getColumnMetaData()[0].getName();
            }
        }
        return propertyName;
    }

    private List<Query.SortPredicate> getSortPredicates() {
        ArrayList<Object> sortPredicates = Utils.newArrayList(new Object[0]);
        if (this.indexedList) {
            String propertyName = this.getIndexPropertyName();
            Query.SortPredicate sortPredicate = new Query.SortPredicate(propertyName, Query.SortDirection.ASCENDING);
            sortPredicates.add(sortPredicate);
        } else {
            for (OrderMetaData.FieldOrder fieldOrder : this.ownerMemberMetaData.getOrderMetaData().getFieldOrders()) {
                String propertyName = fieldOrder.getFieldName();
                boolean isPrimaryKey = this.isPrimaryKey(propertyName);
                if (isPrimaryKey) {
                    if (fieldOrder.isForward() && sortPredicates.isEmpty()) break;
                    propertyName = "__key__";
                }
                Query.SortPredicate sortPredicate = new Query.SortPredicate(propertyName, fieldOrder.isForward() ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING);
                sortPredicates.add(sortPredicate);
                if (isPrimaryKey) break;
            }
        }
        return sortPredicates;
    }

    boolean isPrimaryKey(String propertyName) {
        return ((DatastoreTable)this.containerTable).getDatastoreField(propertyName).isPrimaryKey();
    }
}

