/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GuiceFilter
implements Filter {
    static final ThreadLocal<Context> localContext = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Context previous = localContext.get();
        try {
            localContext.set(new Context((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse));
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            localContext.set(previous);
        }
    }

    static HttpServletRequest getRequest() {
        return GuiceFilter.getContext().getRequest();
    }

    static HttpServletResponse getResponse() {
        return GuiceFilter.getContext().getResponse();
    }

    static Context getContext() {
        Context context = localContext.get();
        if (context == null) {
            throw new RuntimeException("Please apply " + GuiceFilter.class.getName() + " to any request which uses servlet scopes.");
        }
        return context;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    static class Context {
        final HttpServletRequest request;
        final HttpServletResponse response;

        Context(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        HttpServletRequest getRequest() {
            return this.request;
        }

        HttpServletResponse getResponse() {
            return this.response;
        }
    }
}

