/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.expression.ArrayStoreQueryable;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractArrayStoreSpecialization;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractArrayStore
extends ElementContainerStore
implements ArrayStore,
ArrayStoreQueryable {
    protected AbstractArrayStore(StoreManager storeMgr, ClassLoaderResolver clr, AbstractArrayStoreSpecialization specialization) {
        super(storeMgr, clr, specialization);
    }

    public List getArray(StateManager ownerSM) {
        Iterator iter = this.iterator(ownerSM);
        ArrayList elements = new ArrayList();
        while (iter.hasNext()) {
            Object obj = iter.next();
            elements.add(obj);
        }
        return elements;
    }

    public void clear(StateManager ownerSM) {
        HashSet dependentElements = null;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        this.getSpecialization().clear(ownerSM, this);
        if (dependentElements != null && dependentElements.size() > 0) {
            ownerSM.getObjectManager().deleteObjects(dependentElements.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(StateManager ownerSM, Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return true;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.validateElementForWriting(ownerSM, obj, null);
        }
        boolean modified = false;
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = this.allowsBatching() && length > 1;
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            this.getSpecialization().processBatchedWrites(mconn);
            try {
                Object element = null;
                for (int i = 0; i < length; ++i) {
                    element = Array.get(array, i);
                    try {
                        int[] rc = this.getSpecialization().internalAdd(ownerSM, this, element, mconn, batched, i, i == length - 1);
                        if (rc == null) continue;
                        for (int j = 0; j < rc.length; ++j) {
                            if (rc[j] <= 0) continue;
                            modified = true;
                        }
                        continue;
                    }
                    catch (MappedDatastoreException mde) {
                        mde.printStackTrace();
                        exceptions.add(mde);
                        NucleusLogger.DATASTORE.error(mde);
                    }
                }
                Object var14_15 = null;
                mconn.release();
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                mconn.release();
                throw throwable;
            }
        }
        catch (MappedDatastoreException e) {
            e.printStackTrace();
            exceptions.add(e);
            NucleusLogger.DATASTORE.error(e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("056009", (Object)((Exception)exceptions.get(0)).getMessage());
            NucleusLogger.DATASTORE.error(msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), ownerSM.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int position) {
        this.validateElementForWriting(sm, element, null);
        boolean modified = false;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                int[] returnCode = this.getSpecialization().internalAdd(sm, this, element, mconn, false, position, true);
                if (returnCode[0] > 0) {
                    modified = true;
                }
                Object var9_9 = null;
                mconn.release();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                mconn.release();
                throw throwable;
            }
        }
        catch (MappedDatastoreException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)e.getMessage()), e.getCause());
        }
        return modified;
    }

    protected abstract QueryExpression getIteratorStatement(StateManager var1);

    public Iterator iterator(StateManager ownerSM) {
        QueryExpression stmt = this.getIteratorStatement(ownerSM);
        if (stmt == null) {
            throw new NucleusException(LOCALISER.msg("056005")).setFatal();
        }
        ResultObjectFactory rof = this.newResultObjectFactory(ownerSM, stmt, false, true);
        ObjectManager om = ownerSM.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        return this.getSpecialization().iterator(this, ownerSM, om, tx, useUpdateLock, stmt, rof);
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier arrayTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, arrayTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(arrayTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        stmt.select(arrayTableAlias, this.elementMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier arrayTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, arrayTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(arrayTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.storeMgr.getMappingManager().getMapping(String.class);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    private AbstractArrayStoreSpecialization getSpecialization() {
        return (AbstractArrayStoreSpecialization)this.specialization;
    }
}

