/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import java.io.Serializable;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.Counter;

public class CounterImpl
implements Counter,
Serializable {
    private static final long serialVersionUID = 7996279151817598904L;
    private String identifier;
    private String listStyle;
    private String separator;

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setListStyle(String listStyle) {
        this.listStyle = listStyle;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public CounterImpl(boolean separatorSpecified, LexicalUnit lu) throws DOMException {
        LexicalUnit next = lu;
        this.identifier = next.getStringValue();
        next = next.getNextLexicalUnit();
        if (next != null) {
            if (next.getLexicalUnitType() != 0) {
                throw new DOMException(12, "Counter parameters must be separated by ','.");
            }
            next = next.getNextLexicalUnit();
            if (separatorSpecified && next != null) {
                this.separator = next.getStringValue();
                if ((next = next.getNextLexicalUnit()) != null) {
                    if (next.getLexicalUnitType() != 0) {
                        throw new DOMException(12, "Counter parameters must be separated by ','.");
                    }
                    next = next.getNextLexicalUnit();
                }
            }
            if (next != null) {
                this.listStyle = next.getStringValue();
                if ((next = next.getNextLexicalUnit()) != null) {
                    throw new DOMException(12, "Too many parameters for counter function.");
                }
            }
        }
    }

    public CounterImpl() {
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getListStyle() {
        return this.listStyle;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.separator == null) {
            sb.append("counter(");
        } else {
            sb.append("counters(");
        }
        sb.append(this.identifier);
        if (this.separator != null) {
            sb.append(", \"").append(this.separator).append("\"");
        }
        if (this.listStyle != null) {
            sb.append(", ").append(this.listStyle);
        }
        sb.append(")");
        return sb.toString();
    }
}

