/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.dev.CompositeIndexManager;
import com.google.appengine.api.datastore.dev.ValidatedQuery;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.storage.onestore.PropertyType;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalDatastoreService
implements LocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalDatastoreService.class.getName());
    static final int DEFAULT_BATCH_SIZE = 20;
    public static final String MAX_QUERY_LIFETIME_PROPERTY = "datastore.max_query_lifetime";
    private static final int DEFAULT_MAX_QUERY_LIFETIME = 30000;
    public static final String MAX_TRANSACTION_LIFETIME_PROPERTY = "datastore.max_txn_lifetime";
    private static final int DEFAULT_MAX_TRANSACTION_LIFETIME = 30000;
    public static final String STORE_DELAY_PROPERTY = "datastore.store_delay";
    static final int DEFAULT_STORE_DELAY_MS = 30000;
    public static final String BACKING_STORE_PROPERTY = "datastore.backing_store";
    public static final String NO_STORAGE_PROPERTY = "datastore.no_storage";
    static final String ENTITY_GROUP_MESSAGE = "can't operate on multiple entity groups in a single transaction.";
    static final String CONTENTION_MESSAGE = "too much contention on these datastore entities. please try again.";
    static final String HANDLE_NOT_FOUND_MESSAGE_FORMAT = "handle %s not found";
    static final String GET_SCHEMA_START_PAST_END = "start_kind must be <= end_kind";
    private final AtomicLong entityId = new AtomicLong(1L);
    private final AtomicLong queryId = new AtomicLong(0L);
    private String backingStore;
    private Map<String, Profile> profiles = Collections.synchronizedMap(new HashMap());
    private static final long MAX_BATCH_GET_KEYS = 1000000000L;
    private final Map<Long, LiveQuery> liveQueries = Collections.synchronizedMap(new HashMap());
    private final Map<Long, LiveTxn> liveTxns = Collections.synchronizedMap(new HashMap());
    private int maxQueryLifetimeMs;
    private int maxTransactionLifetimeMs;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(2);
    private final RemoveStaleQueries removeStaleQueriesTask = new RemoveStaleQueries();
    private final RemoveStaleTransactions removeStaleTransactionsTask = new RemoveStaleTransactions();
    private final PersistDatastore persistDatastoreTask = new PersistDatastore();
    private final AtomicInteger transactionHandleProvider = new AtomicInteger(0);
    private int storeDelayMs;
    private boolean dirty;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private boolean noStorage;
    private Thread shutdownHook;
    private static final Comparator<Comparable<Object>> MULTI_TYPE_COMPARATOR = new Comparator<Comparable<Object>>(){

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            Integer comp2TypeRank;
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Integer comp1TypeRank = DataTypeTranslator.getTypeRank(o1.getClass());
            if (comp1TypeRank.equals(comp2TypeRank = Integer.valueOf(DataTypeTranslator.getTypeRank(o2.getClass())))) {
                return o1.compareTo(o2);
            }
            return comp1TypeRank.compareTo(comp2TypeRank);
        }
    };

    public void clearProfiles() {
        this.profiles.clear();
    }

    public LocalDatastoreService() {
        this.setMaxQueryLifetime(30000);
        this.setMaxTransactionLifetime(30000);
        this.setStoreDelay(30000);
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String storeFile = properties.get(BACKING_STORE_PROPERTY);
        if (storeFile == null) {
            File dir = GenerationDirectory.getGenerationDirectory((File)context.getAppDir());
            dir.mkdirs();
            storeFile = dir.getAbsolutePath() + File.separator + "local_db.bin";
        }
        this.setBackingStore(storeFile);
        String noStorageProp = properties.get(NO_STORAGE_PROPERTY);
        if (noStorageProp != null) {
            this.noStorage = Boolean.valueOf(noStorageProp);
        }
        String storeDelayTime = properties.get(STORE_DELAY_PROPERTY);
        this.storeDelayMs = LocalDatastoreService.parseInt(storeDelayTime, this.storeDelayMs, STORE_DELAY_PROPERTY);
        String maxQueryLifetime = properties.get(MAX_QUERY_LIFETIME_PROPERTY);
        this.maxQueryLifetimeMs = LocalDatastoreService.parseInt(maxQueryLifetime, this.maxQueryLifetimeMs, MAX_QUERY_LIFETIME_PROPERTY);
        String maxTxnLifetime = properties.get(MAX_TRANSACTION_LIFETIME_PROPERTY);
        this.maxTransactionLifetimeMs = LocalDatastoreService.parseInt(maxTxnLifetime, this.maxTransactionLifetimeMs, MAX_TRANSACTION_LIFETIME_PROPERTY);
        CompositeIndexManager.getInstance().setAppDir(context.getAppDir());
    }

    private static int parseInt(String valStr, int defaultVal, String propName) {
        if (valStr != null) {
            try {
                return Integer.parseInt(valStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Expected a numeric value for property " + propName + "but received, " + valStr + ". Resetting property to the default.");
            }
        }
        return defaultVal;
    }

    public void start() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalDatastoreService.this.start_();
                return null;
            }
        });
    }

    private void start_() {
        if (!this.noStorage) {
            this.load();
        }
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleQueriesTask, this.maxQueryLifetimeMs * 5, this.maxQueryLifetimeMs * 5, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleTransactionsTask, this.maxTransactionLifetimeMs * 5, this.maxTransactionLifetimeMs * 5, TimeUnit.MILLISECONDS);
        if (!this.noStorage) {
            this.scheduler.scheduleWithFixedDelay(this.persistDatastoreTask, this.storeDelayMs, this.storeDelayMs, TimeUnit.MILLISECONDS);
        }
        this.shutdownHook = new Thread(){

            public void run() {
                LocalDatastoreService.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void stop() {
        this.scheduler.shutdown();
        if (!this.noStorage) {
            this.persistDatastoreTask.run();
        }
        this.liveQueries.clear();
        this.liveTxns.clear();
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void setMaxQueryLifetime(int milliseconds) {
        this.maxQueryLifetimeMs = milliseconds;
    }

    public void setMaxTransactionLifetime(int milliseconds) {
        this.maxTransactionLifetimeMs = milliseconds;
    }

    public void setBackingStore(String backingStore) {
        this.backingStore = backingStore;
    }

    public void setStoreDelay(int delayMs) {
        this.storeDelayMs = delayMs;
    }

    public void setNoStorage(boolean noStorage) {
        this.noStorage = noStorage;
    }

    public String getPackage() {
        return "datastore_v3";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.GetResponse get(LocalRpcService.Status status, DatastorePb.GetRequest request) {
        DatastorePb.GetResponse response = new DatastorePb.GetResponse();
        LiveTxn liveTxn = null;
        for (OnestoreEntity.Reference key : request.keys()) {
            Profile profile;
            String app = key.getApp();
            OnestoreEntity.Path groupPath = this.getGroup(key);
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            DatastorePb.GetResponse.Entity group = response.addEntity();
            Profile profile2 = profile = this.getOrCreateProfile(app);
            synchronized (profile2) {
                OnestoreEntity.EntityProto entity;
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
                    }
                    eg.addTransaction(liveTxn);
                }
                if ((entity = eg.get(liveTxn, key)) != null) {
                    group.getMutableEntity().copyFrom((ProtocolMessage)entity);
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.PutResponse put(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.PutResponse putResponse = this.putImpl(status, request);
            return putResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.PutResponse putImpl(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        OnestoreEntity.Reference key;
        DatastorePb.PutResponse response = new DatastorePb.PutResponse();
        ArrayList<OnestoreEntity.EntityProto> clones = new ArrayList<OnestoreEntity.EntityProto>();
        String app = null;
        Profile profile = null;
        LiveTxn liveTxn = null;
        for (OnestoreEntity.EntityProto entity : request.entitys()) {
            OnestoreEntity.EntityProto clone = (OnestoreEntity.EntityProto)entity.clone();
            clones.add(clone);
            assert (clone.hasKey());
            key = clone.getKey();
            assert (key.getPath().elementSize() > 0);
            if (app == null) {
                app = key.getApp();
                profile = this.getOrCreateProfile(app);
            }
            clone.getMutableKey().setApp(app);
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            if (!lastPath.hasId() && !lastPath.hasName()) {
                lastPath.setId(this.entityId.getAndIncrement());
            }
            if (clone.getEntityGroup().elementSize() == 0) {
                OnestoreEntity.Path group = clone.getMutableEntityGroup();
                OnestoreEntity.Path.Element root = (OnestoreEntity.Path.Element)key.getPath().elements().get(0);
                OnestoreEntity.Path.Element pathElement = group.addElement();
                pathElement.setType(root.getType());
                if (root.hasName()) {
                    pathElement.setName(root.getName());
                    continue;
                }
                pathElement.setId(root.getId());
                continue;
            }
            assert (clone.hasEntityGroup() && clone.getEntityGroup().elementSize() > 0);
        }
        Profile profile2 = profile;
        synchronized (profile2) {
            for (OnestoreEntity.EntityProto clone : clones) {
                key = clone.getKey();
                String kind = ((OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements())).getType();
                Extent extent = this.getOrCreateExtent(profile, kind);
                Profile.EntityGroup eg = profile.getGroup(clone.getEntityGroup());
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
                    }
                    eg.addTransaction(liveTxn);
                    liveTxn.addWrittenEntity(clone);
                } else {
                    eg.incrementVersion();
                    extent.getEntities().put(key, clone);
                    this.dirty = true;
                }
                response.mutableKeys().add(clone.getKey());
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.DeleteResponse delete(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.DeleteResponse deleteResponse = this.deleteImpl(status, request);
            return deleteResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private OnestoreEntity.Path getGroup(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.DeleteResponse deleteImpl(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        LiveTxn liveTxn = null;
        for (OnestoreEntity.Reference key : request.keys()) {
            String app = key.getApp();
            OnestoreEntity.Path group = this.getGroup(key);
            Profile profile = this.getOrCreateProfile(app);
            if (request.hasTransaction()) {
                if (liveTxn == null) {
                    liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
                }
                Profile profile2 = profile;
                synchronized (profile2) {
                    Profile.EntityGroup eg = profile.getGroup(group);
                    eg.addTransaction(liveTxn);
                    liveTxn.addDeletedEntity(key);
                    continue;
                }
            }
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            String kind = lastPath.getType();
            Map<String, Extent> extents = profile.getExtents();
            Extent extent = extents.get(kind);
            if (extent == null) continue;
            Profile profile3 = profile;
            synchronized (profile3) {
                Profile.EntityGroup eg = profile.getGroup(group);
                if (extent.getEntities().containsKey(key)) {
                    eg.incrementVersion();
                    extent.getEntities().remove(key);
                    this.dirty = true;
                }
            }
        }
        return new DatastorePb.DeleteResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.QueryResult runQuery(LocalRpcService.Status status, DatastorePb.Query query) {
        Object liveTxn;
        Profile profile;
        final ValidatedQuery validatedQuery = new ValidatedQuery(query);
        query = validatedQuery.getQuery();
        String app = query.getApp();
        Profile profile2 = profile = this.getOrCreateProfile(app);
        synchronized (profile2) {
            if (query.hasTransaction()) {
                OnestoreEntity.Path groupPath = this.getGroup(query.getAncestor());
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, query.getTransaction().getHandle());
                eg.addTransaction((LiveTxn)liveTxn);
            }
        }
        Iterable<Object> queryEntities = null;
        Map<String, Extent> extents = profile.getExtents();
        Extent extent = extents.get(query.getKind());
        if (extent != null) {
            liveTxn = extent;
            synchronized (liveTxn) {
                queryEntities = new ArrayList<OnestoreEntity.EntityProto>(extent.getEntities().values());
            }
        }
        if (queryEntities == null) {
            queryEntities = Collections.emptyList();
        }
        if (query.hasAncestor()) {
            final List ancestorPath = query.getAncestor().getPath().elements();
            queryEntities = Iterables.filter(queryEntities, (Predicate)new Predicate<OnestoreEntity.EntityProto>(){

                public boolean apply(OnestoreEntity.EntityProto entity) {
                    List path = entity.getKey().getPath().elements();
                    return path.size() >= ancestorPath.size() && ((Object)path.subList(0, ancestorPath.size())).equals(ancestorPath);
                }
            });
        }
        ArrayList<OnestoreEntity.EntityProto> filteredResults = new ArrayList<OnestoreEntity.EntityProto>();
        block6: for (OnestoreEntity.EntityProto queryEntity : queryEntities) {
            for (DatastorePb.Query.Filter filter : query.filters()) {
                OnestoreEntity.Property filterProperty = filter.getProperty(0);
                Comparable filterValue = DataTypeTranslator.getComparablePropertyValue((OnestoreEntity.Property)filterProperty);
                assert (filter.getOpEnum() != DatastorePb.Query.Filter.Operator.IN);
                Collection entityProps = DataTypeTranslator.findIndexedPropertiesOnPb((OnestoreEntity.EntityProto)queryEntity, (String)filterProperty.getName());
                if (entityProps.isEmpty()) continue block6;
                boolean atLeastOneValueMatches = false;
                for (OnestoreEntity.Property entityProp : entityProps) {
                    Comparable singleValue = DataTypeTranslator.getComparablePropertyValue((OnestoreEntity.Property)entityProp);
                    if (!this.matches(singleValue, filterValue, filter.getOpEnum())) continue;
                    atLeastOneValueMatches = true;
                    break;
                }
                if (atLeastOneValueMatches) continue;
                continue block6;
            }
            filteredResults.add(queryEntity);
        }
        HashSet<String> orderProperties = new HashSet<String>();
        for (DatastorePb.Query.Order order : query.orders()) {
            orderProperties.add(order.getProperty());
        }
        Iterator protoIt = filteredResults.iterator();
        while (protoIt.hasNext()) {
            OnestoreEntity.EntityProto proto = (OnestoreEntity.EntityProto)protoIt.next();
            HashMap entityProperties = new HashMap();
            DataTypeTranslator.extractIndexedPropertiesFromPb((OnestoreEntity.EntityProto)proto, entityProperties);
            DataTypeTranslator.extractImplicitPropertiesFromPb((OnestoreEntity.EntityProto)proto, entityProperties);
            if (entityProperties.keySet().containsAll(orderProperties)) continue;
            protoIt.remove();
        }
        Comparator<OnestoreEntity.EntityProto> sortComparator = new Comparator<OnestoreEntity.EntityProto>(){

            @Override
            public int compare(OnestoreEntity.EntityProto protoA, OnestoreEntity.EntityProto protoB) {
                for (DatastorePb.Query.Order order : validatedQuery.getQuery().orders()) {
                    int result;
                    String property = order.getProperty();
                    try {
                        List<Comparable<Object>> aValues = LocalDatastoreService.getComparablePropertyValues(protoA, property);
                        List<Comparable<Object>> bValues = LocalDatastoreService.getComparablePropertyValues(protoB, property);
                        Comparable<Object> minA = LocalDatastoreService.multiTypeMin(aValues);
                        Comparable<Object> minB = LocalDatastoreService.multiTypeMin(bValues);
                        result = MULTI_TYPE_COMPARATOR.compare(minA, minB);
                    }
                    catch (NonExistentPropertyException e) {
                        throw new IllegalStateException("Trying to sort on a non-existent property.");
                    }
                    if (result == 0) continue;
                    if (order.getDirectionEnum() == DatastorePb.Query.Order.Direction.DESCENDING) {
                        result = -result;
                    }
                    return result;
                }
                return 0;
            }
        };
        Collections.sort(filteredResults, sortComparator);
        if (query.hasOffset()) {
            int offset = Math.min(filteredResults.size(), query.getOffset());
            filteredResults = new ArrayList(filteredResults.subList(offset, filteredResults.size()));
        }
        if (query.hasLimit()) {
            int limit = Math.min(filteredResults.size(), query.getLimit());
            filteredResults = new ArrayList(filteredResults.subList(0, limit));
        }
        long cursor = this.queryId.getAndIncrement();
        this.liveQueries.put(cursor, new LiveQuery(filteredResults, System.currentTimeMillis(), query.isKeysOnly()));
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                CompositeIndexManager.getInstance().processQuery(validatedQuery.getQuery());
                return null;
            }
        });
        int count = 0;
        count = query.hasCount() ? query.getCount() : (query.hasLimit() ? query.getLimit() : 20);
        DatastorePb.NextRequest nextReq = new DatastorePb.NextRequest();
        nextReq.getMutableCursor().setCursor(cursor);
        nextReq.setCount(count);
        return this.next(status, nextReq);
    }

    static Comparable<Object> multiTypeMin(Collection<Comparable<Object>> comparables) {
        Comparable<Object> smallest = null;
        for (Comparable<Object> comp : comparables) {
            if (smallest == null) {
                smallest = comp;
                continue;
            }
            if (MULTI_TYPE_COMPARATOR.compare(comp, smallest) >= 0) continue;
            smallest = comp;
        }
        return smallest;
    }

    static List<Comparable<Object>> getComparablePropertyValues(OnestoreEntity.EntityProto entityProto, String propertyName) throws NonExistentPropertyException {
        Collection entityProperties = DataTypeTranslator.findIndexedPropertiesOnPb((OnestoreEntity.EntityProto)entityProto, (String)propertyName);
        if (entityProperties.isEmpty()) {
            throw new NonExistentPropertyException();
        }
        ArrayList<Comparable<Object>> values = new ArrayList<Comparable<Object>>(entityProperties.size());
        for (OnestoreEntity.Property prop : entityProperties) {
            values.add(DataTypeTranslator.getComparablePropertyValue((OnestoreEntity.Property)prop));
        }
        return values;
    }

    private static <T> T safeGetFromExpiringMap(Map<Long, T> map, long key) {
        T value = map.get(key);
        if (value == null) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), String.format(HANDLE_NOT_FOUND_MESSAGE_FORMAT, key));
        }
        return value;
    }

    public DatastorePb.QueryResult next(LocalRpcService.Status status, DatastorePb.NextRequest request) {
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        long cursorId = request.getCursor().getCursor();
        LiveQuery liveQuery = LocalDatastoreService.safeGetFromExpiringMap(this.liveQueries, cursorId);
        List<OnestoreEntity.EntityProto> queryContents = liveQuery.getEntities();
        int count = 20;
        if (request.hasCount()) {
            count = request.getCount();
        }
        int end = Math.min(count, queryContents.size());
        List<OnestoreEntity.EntityProto> subList = queryContents.subList(0, end);
        ArrayList<OnestoreEntity.EntityProto> nextResults = new ArrayList<OnestoreEntity.EntityProto>(subList);
        subList.clear();
        for (OnestoreEntity.EntityProto proto : nextResults) {
            result.addResult(proto);
        }
        result.getMutableCursor().setCursor(cursorId);
        result.setMoreResults(queryContents.size() > 0);
        result.setKeysOnly(liveQuery.isKeysOnly());
        return result;
    }

    public ApiBasePb.Integer64Proto count(LocalRpcService.Status status, DatastorePb.Query request) {
        LocalRpcService.Status queryStatus = new LocalRpcService.Status();
        DatastorePb.QueryResult queryResult = this.runQuery(queryStatus, request);
        long cursor = queryResult.getCursor().getCursor();
        List<OnestoreEntity.EntityProto> queryData = LocalDatastoreService.safeGetFromExpiringMap(this.liveQueries, cursor).getEntities();
        this.liveQueries.remove(cursor);
        ApiBasePb.Integer64Proto results = new ApiBasePb.Integer64Proto();
        results.setValue((long)(queryData.size() + queryResult.resultSize()));
        return results;
    }

    public ApiBasePb.VoidProto deleteCursor(LocalRpcService.Status status, DatastorePb.Cursor request) {
        this.liveQueries.remove(request.getCursor());
        return new ApiBasePb.VoidProto();
    }

    public DatastorePb.QueryExplanation explain(LocalRpcService.Status status, DatastorePb.Query req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public DatastorePb.Transaction beginTransaction(LocalRpcService.Status status, ApiBasePb.VoidProto req) {
        DatastorePb.Transaction txn = new DatastorePb.Transaction().setHandle((long)this.transactionHandleProvider.getAndIncrement());
        this.liveTxns.put(txn.getHandle(), new LiveTxn(System.currentTimeMillis()));
        return txn;
    }

    private void removeLiveTxn(long handle) {
        LiveTxn txn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, handle);
        txn.close();
        this.liveTxns.remove(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.CommitResponse commit(LocalRpcService.Status status, DatastorePb.Transaction req) {
        LiveTxn liveTxn;
        LiveTxn liveTxn2 = liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, req.getHandle());
        synchronized (liveTxn2) {
            this.removeLiveTxn(req.getHandle());
            if (liveTxn.isDirty()) {
                try {
                    this.globalLock.readLock().lock();
                    this.commitImpl(liveTxn);
                }
                finally {
                    this.globalLock.readLock().unlock();
                }
            }
        }
        return new DatastorePb.CommitResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitImpl(LiveTxn liveTxn) {
        Profile profile = this.profiles.get(liveTxn.getApp());
        assert (profile != null);
        Profile.EntityGroup eg = liveTxn.getEntityGroup();
        Profile profile2 = profile;
        synchronized (profile2) {
            Extent extent;
            Map<String, Extent> extents;
            String kind;
            OnestoreEntity.Path.Element lastPath;
            liveTxn.checkEntityGroupVersion();
            eg.incrementVersion();
            for (OnestoreEntity.EntityProto entity : liveTxn.getWrittenEntities()) {
                lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(entity.getKey().getPath().elements());
                kind = lastPath.getType();
                extents = profile.getExtents();
                extent = this.getOrCreateExtent(profile, kind);
                extent.getEntities().put(entity.getKey(), entity);
            }
            for (OnestoreEntity.Reference key : liveTxn.getDeletedKeys()) {
                lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
                kind = lastPath.getType();
                extents = profile.getExtents();
                extent = extents.get(kind);
                if (extent == null) continue;
                extent.getEntities().remove(key);
            }
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiBasePb.VoidProto rollback(LocalRpcService.Status status, DatastorePb.Transaction req) {
        LiveTxn liveTxn;
        LiveTxn liveTxn2 = liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, req.getHandle());
        synchronized (liveTxn2) {
            this.removeLiveTxn(req.getHandle());
        }
        return new ApiBasePb.VoidProto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.Schema getSchema(LocalRpcService.Status status, DatastorePb.GetSchemaRequest req) {
        Map<String, Extent> extents;
        if (req.hasStartKind() && req.hasEndKind()) {
            Preconditions.checkArgument((req.getStartKind().compareTo(req.getEndKind()) <= 0 ? 1 : 0) != 0, (Object)GET_SCHEMA_START_PAST_END);
        }
        DatastorePb.Schema schema = new DatastorePb.Schema();
        Profile profile = this.getOrCreateProfile(req.getApp());
        Map<String, Extent> map = extents = profile.getExtents();
        synchronized (map) {
            for (Map.Entry<String, Extent> entry : extents.entrySet()) {
                String kind = entry.getKey();
                if (req.hasStartKind() && kind.compareTo(req.getStartKind()) < 0 || req.hasEndKind() && kind.compareTo(req.getEndKind()) > 0 || entry.getValue().getEntities().isEmpty()) continue;
                OnestoreEntity.EntityProto allPropsProto = new OnestoreEntity.EntityProto();
                schema.addKind(allPropsProto);
                OnestoreEntity.Path path = new OnestoreEntity.Path();
                path.addElement().setType(kind);
                allPropsProto.setKey(new OnestoreEntity.Reference().setApp(req.getApp()).setPath(path));
                allPropsProto.getMutableEntityGroup();
                if (!req.isProperties()) continue;
                HashMap<String, OnestoreEntity.Property> allProps = new HashMap<String, OnestoreEntity.Property>();
                for (OnestoreEntity.EntityProto entity : entry.getValue().getEntities().values()) {
                    for (OnestoreEntity.Property prop : entity.propertys()) {
                        OnestoreEntity.Property schemaProp = (OnestoreEntity.Property)allProps.get(prop.getName());
                        if (schemaProp == null) {
                            schemaProp = allPropsProto.addProperty().setName(prop.getName()).setMultiple(false);
                            allProps.put(prop.getName(), schemaProp);
                        }
                        PropertyType type = PropertyType.getType((OnestoreEntity.PropertyValue)prop.getValue());
                        schemaProp.getMutableValue().mergeFrom(type.placeholderValue);
                    }
                }
            }
        }
        schema.setMoreResults(false);
        return schema;
    }

    public ApiBasePb.Integer64Proto createIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto updateIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public DatastorePb.CompositeIndices getIndices(LocalRpcService.Status status, ApiBasePb.StringProto req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto deleteIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.AllocateIdsResponse allocateIds(LocalRpcService.Status status, DatastorePb.AllocateIdsRequest req) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.AllocateIdsResponse allocateIdsResponse = this.allocateIdsImpl(req);
            return allocateIdsResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private DatastorePb.AllocateIdsResponse allocateIdsImpl(DatastorePb.AllocateIdsRequest req) {
        if (req.getSize() > 1000000000L) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "cannot get more than 1000000000 keys in a single call");
        }
        long start = this.entityId.getAndAdd(req.getSize());
        return new DatastorePb.AllocateIdsResponse().setStart(start).setEnd(start + req.getSize() - 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Profile getOrCreateProfile(String app) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            Profile profile = this.profiles.get(app);
            if (profile == null) {
                profile = new Profile();
                this.profiles.put(app, profile);
            }
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extent getOrCreateExtent(Profile profile, String kind) {
        Map<String, Extent> extents;
        Map<String, Extent> map = extents = profile.getExtents();
        synchronized (map) {
            Extent e = extents.get(kind);
            if (e == null) {
                e = new Extent();
                extents.put(kind, e);
            }
            return e;
        }
    }

    private boolean matches(Comparable<Object> value1, Comparable<Object> value2, DatastorePb.Query.Filter.Operator op) {
        switch (op) {
            case EQUAL: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) == 0;
            }
            case GREATER_THAN: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) >= 0;
            }
            case LESS_THAN: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return MULTI_TYPE_COMPARATOR.compare(value1, value2) <= 0;
            }
        }
        throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), "Unable to perform filter using operator " + op);
    }

    private void load() {
        File backingStoreFile = new File(this.backingStore);
        String path = backingStoreFile.getAbsolutePath();
        if (!backingStoreFile.exists()) {
            logger.log(Level.INFO, "The backing store, " + path + ", does not exist. " + "It will be created.");
            return;
        }
        try {
            Map profilesOnDisk;
            long start = System.currentTimeMillis();
            ObjectInputStream objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.backingStore)));
            this.entityId.set(objectIn.readLong());
            this.profiles = profilesOnDisk = (Map)objectIn.readObject();
            objectIn.close();
            long end = System.currentTimeMillis();
            logger.log(Level.INFO, "Time to load datastore: " + (end - start) + " ms");
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to find the backing store, " + path);
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
    }

    private static <T> T getLast(List<T> list) {
        return list.get(list.size() - 1);
    }

    static void pruneHasCreationTimeMap(long now, int maxLifetimeMs, Map<Long, ? extends HasCreationTime> hasCreationTimeMap) {
        long deadline = now - (long)maxLifetimeMs;
        Iterator<Map.Entry<Long, ? extends HasCreationTime>> queryIt = hasCreationTimeMap.entrySet().iterator();
        while (queryIt.hasNext()) {
            Map.Entry<Long, ? extends HasCreationTime> entry = queryIt.next();
            HasCreationTime query = entry.getValue();
            if (query.getCreationTime() >= deadline) continue;
            queryIt.remove();
        }
    }

    void removeStaleQueriesNow() {
        this.removeStaleQueriesTask.run();
    }

    void removeStaleTxnsNow() {
        this.removeStaleTransactionsTask.run();
    }

    private class PersistDatastore
    implements Runnable {
        private PersistDatastore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LocalDatastoreService.this.globalLock.writeLock().lock();
                this.privilegedPersist();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to save the datastore", e);
            }
            finally {
                LocalDatastoreService.this.globalLock.writeLock().unlock();
            }
        }

        private void privilegedPersist() throws IOException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        PersistDatastore.this.persist();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException(t);
            }
        }

        private void persist() throws IOException {
            if (!LocalDatastoreService.this.dirty) {
                return;
            }
            long start = System.currentTimeMillis();
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(LocalDatastoreService.this.backingStore)));
            objectOut.writeLong(LocalDatastoreService.this.entityId.get());
            objectOut.writeObject(LocalDatastoreService.this.profiles);
            objectOut.close();
            LocalDatastoreService.this.dirty = false;
            long end = System.currentTimeMillis();
            logger.log(Level.INFO, "Time to persist datastore: " + (end - start) + " ms");
        }
    }

    private class RemoveStaleTransactions
    implements Runnable {
        private RemoveStaleTransactions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = LocalDatastoreService.this.liveTxns;
            synchronized (map) {
                LocalDatastoreService.pruneHasCreationTimeMap(System.currentTimeMillis(), LocalDatastoreService.this.maxTransactionLifetimeMs, LocalDatastoreService.this.liveTxns);
            }
        }
    }

    private class RemoveStaleQueries
    implements Runnable {
        private RemoveStaleQueries() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = LocalDatastoreService.this.liveQueries;
            synchronized (map) {
                LocalDatastoreService.pruneHasCreationTimeMap(System.currentTimeMillis(), LocalDatastoreService.this.maxQueryLifetimeMs, LocalDatastoreService.this.liveQueries);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LiveTxn
    extends HasCreationTime {
        private Profile.EntityGroup entityGroup;
        private Long entityGroupVersion;
        private final Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> written = new HashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();
        private final Set<OnestoreEntity.Reference> deleted = Collections.synchronizedSet(new HashSet());
        private String app;

        public LiveTxn(long creationTime) {
            super(creationTime);
        }

        public synchronized void setEntityGroup(Profile.EntityGroup newEntityGroup) {
            if (newEntityGroup == null) {
                throw new NullPointerException("entityGroup cannot be null");
            }
            if (this.entityGroupVersion == null) {
                this.entityGroupVersion = newEntityGroup.getVersion();
                this.entityGroup = newEntityGroup;
            }
            if (!newEntityGroup.equals(this.entityGroup)) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "can't operate on multiple entity groups in a single transaction. found both " + this.entityGroup + " and " + newEntityGroup);
            }
        }

        public synchronized Profile.EntityGroup getEntityGroup() {
            return this.entityGroup;
        }

        public synchronized void checkEntityGroupVersion() {
            if (!this.entityGroupVersion.equals(this.entityGroup.getVersion())) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), LocalDatastoreService.CONTENTION_MESSAGE);
            }
        }

        public synchronized Long getEntityGroupVersion() {
            return this.entityGroupVersion;
        }

        public synchronized void addWrittenEntity(OnestoreEntity.EntityProto entity) {
            OnestoreEntity.Reference key = entity.getKey();
            this.app = key.getApp();
            this.written.put(key, entity);
            this.deleted.remove(key);
        }

        public synchronized void addDeletedEntity(OnestoreEntity.Reference key) {
            this.app = key.getApp();
            this.deleted.add(key);
            this.written.remove(key);
        }

        public synchronized Collection<OnestoreEntity.EntityProto> getWrittenEntities() {
            return new ArrayList<OnestoreEntity.EntityProto>(this.written.values());
        }

        public synchronized Collection<OnestoreEntity.Reference> getDeletedKeys() {
            return new ArrayList<OnestoreEntity.Reference>(this.deleted);
        }

        public synchronized String getApp() {
            return this.app;
        }

        public synchronized boolean isDirty() {
            return this.written.size() + this.deleted.size() > 0;
        }

        public void close() {
            if (this.entityGroup != null) {
                this.entityGroup.removeTransaction(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LiveQuery
    extends HasCreationTime {
        private final List<OnestoreEntity.EntityProto> entities;
        private final boolean keysOnly;

        public LiveQuery(List<OnestoreEntity.EntityProto> entities, long creationTime, boolean keysOnly) {
            super(creationTime);
            if (entities == null) {
                throw new NullPointerException("entities cannot be null");
            }
            this.keysOnly = keysOnly;
            if (keysOnly) {
                this.entities = new ArrayList<OnestoreEntity.EntityProto>();
                for (OnestoreEntity.EntityProto entity : entities) {
                    this.entities.add(((OnestoreEntity.EntityProto)entity.clone()).clearOwner().clearProperty().clearRawProperty());
                }
            } else {
                this.entities = entities;
            }
        }

        public List<OnestoreEntity.EntityProto> getEntities() {
            return this.entities;
        }

        public boolean isKeysOnly() {
            return this.keysOnly;
        }
    }

    static abstract class HasCreationTime {
        private final long creationTime;

        HasCreationTime(long creationTime) {
            this.creationTime = creationTime;
        }

        long getCreationTime() {
            return this.creationTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Extent
    implements Serializable {
        private Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> entities = new LinkedHashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();

        private Extent() {
        }

        public Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> getEntities() {
            return this.entities;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Profile
    implements Serializable {
        private final Map<String, Extent> extents = Collections.synchronizedMap(new HashMap());
        private transient Map<OnestoreEntity.Path, EntityGroup> groups;

        private Profile() {
        }

        public Map<String, Extent> getExtents() {
            return this.extents;
        }

        public synchronized EntityGroup getGroup(OnestoreEntity.Path path) {
            EntityGroup group;
            if (this.groups == null) {
                this.groups = new HashMap<OnestoreEntity.Path, EntityGroup>();
            }
            if ((group = this.groups.get(path)) == null) {
                group = new EntityGroup(path);
                this.groups.put(path, group);
            }
            return group;
        }

        private class EntityGroup {
            private final OnestoreEntity.Path path;
            private final AtomicLong version = new AtomicLong();
            private final WeakHashMap<LiveTxn, Profile> snapshots = new WeakHashMap();

            private EntityGroup(OnestoreEntity.Path path) {
                this.path = path;
            }

            public long getVersion() {
                return this.version.get();
            }

            public void incrementVersion() {
                long oldVersion = this.version.getAndIncrement();
                Profile snapshot = null;
                for (LiveTxn txn : this.snapshots.keySet()) {
                    if (txn.getEntityGroupVersion() != oldVersion) continue;
                    if (snapshot == null) {
                        snapshot = this.takeSnapshot();
                    }
                    this.snapshots.put(txn, snapshot);
                }
            }

            public OnestoreEntity.EntityProto get(LiveTxn liveTxn, OnestoreEntity.Reference key) {
                OnestoreEntity.Path.Element lastPath;
                Profile profile = this.getSnapshot(liveTxn);
                Map<String, Extent> extents = profile.getExtents();
                Extent extent = extents.get((lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements())).getType());
                if (extent != null) {
                    Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> entities = extent.getEntities();
                    return entities.get(key);
                }
                return null;
            }

            public void addTransaction(LiveTxn txn) {
                txn.setEntityGroup(this);
                if (!this.snapshots.containsKey(txn)) {
                    this.snapshots.put(txn, null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeTransaction(LiveTxn txn) {
                Profile profile = Profile.this;
                synchronized (profile) {
                    this.snapshots.remove(txn);
                }
            }

            private Profile getSnapshot(LiveTxn txn) {
                if (txn == null) {
                    return Profile.this;
                }
                Profile snapshot = this.snapshots.get(txn);
                if (snapshot == null) {
                    return Profile.this;
                }
                return snapshot;
            }

            private Profile takeSnapshot() {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(Profile.this);
                    oos.close();
                    ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    return (Profile)ois.readObject();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to take transaction snapshot.", ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Unable to take transaction snapshot.", ex);
                }
            }

            public String toString() {
                return this.path.toString();
            }
        }
    }

    static final class NonExistentPropertyException
    extends Exception {
        NonExistentPropertyException() {
        }
    }
}

