/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jdo.PersistenceManagerFactory;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.spi.PersistenceUnitInfo;
import org.datanucleus.jpa.EntityManagerFactoryImpl;
import org.datanucleus.jpa.PersistenceProviderImpl;
import org.datanucleus.store.appengine.ConcurrentHashMapHelper;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.jpa.DatastoreEntityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreEntityManagerFactory
extends EntityManagerFactoryImpl {
    private static final ConcurrentHashMap<String, AtomicInteger> NUM_INSTANCES_PER_PERSISTENCE_UNIT = new ConcurrentHashMap();
    public static final String DISABLE_DUPLICATE_EMF_EXCEPTION_PROPERTY = "appengine.orm.disable.duplicate.emf.exception";
    private static final String DUPLICATE_EMF_ERROR_FORMAT = "Application code attempted to create a EntityManagerFactory named %s, but one with this name already exists!  Instances of EntityManagerFactory are extremely slow to create and it is usually not necessary to create one with a given name more than once.  Instead, create a singleton and share it throughout your code.  If you really do need to create a duplicate EntityManagerFactory (such as for a unittest suite), set the appengine.orm.disable.duplicate.emf.exception system property to avoid this error.";

    public DatastoreEntityManagerFactory(String unitName, Map<String, Object> overridingProps) {
        super(unitName, DatastoreEntityManagerFactory.manageOverridingProps(overridingProps));
        this.checkForRepeatedAllocation(unitName);
    }

    public DatastoreEntityManagerFactory(PersistenceUnitInfo unitInfo, Map<String, Object> overridingProps) {
        super(unitInfo, DatastoreEntityManagerFactory.manageOverridingProps(overridingProps));
        this.checkForRepeatedAllocation(unitInfo.getPersistenceUnitName());
    }

    private static Map<String, Object> manageOverridingProps(Map<String, Object> overridingProps) {
        HashMap<String, Object> propsToReturn = Utils.newHashMap();
        if (overridingProps != null) {
            propsToReturn.putAll(overridingProps);
        }
        if (!propsToReturn.containsKey("javax.persistence.provider")) {
            propsToReturn.put("javax.persistence.provider", PersistenceProviderImpl.class.getName());
        }
        if (!propsToReturn.containsKey("datanucleus.identifier.case")) {
            propsToReturn.put("datanucleus.identifier.case", "PreserveCase");
        }
        return propsToReturn;
    }

    protected EntityManager newEntityManager(PersistenceContextType contextType, PersistenceManagerFactory pmf) {
        return new DatastoreEntityManager((EntityManagerFactory)this, pmf, contextType);
    }

    private static boolean alreadyAllocated(String name) {
        if (name == null) {
            return false;
        }
        AtomicInteger count = ConcurrentHashMapHelper.getCounter(NUM_INSTANCES_PER_PERSISTENCE_UNIT, name);
        return count.incrementAndGet() > 1 && !System.getProperties().containsKey(DISABLE_DUPLICATE_EMF_EXCEPTION_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForRepeatedAllocation(String name) {
        if (DatastoreEntityManagerFactory.alreadyAllocated(name)) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(String.format(DUPLICATE_EMF_ERROR_FORMAT, name));
            }
            throw new IllegalStateException(String.format(DUPLICATE_EMF_ERROR_FORMAT, name));
        }
    }
}

