/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.expression.ExpressionHelper;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStoreSpecialization;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.util.ClassUtils;

public abstract class ElementContainerStore
extends BaseContainerStore {
    protected boolean iterateUsingDiscriminator = false;
    protected ElementInfo[] elementInfo;
    protected AbstractClassMetaData emd;
    protected DatastoreContainerObject containerTable;
    protected JavaTypeMapping elementMapping;
    protected String elementType;
    protected boolean elementsAreEmbedded;
    protected boolean elementsAreSerialised;
    protected boolean elementIsPersistentInterface = false;
    protected JavaTypeMapping orderMapping;
    protected JavaTypeMapping relationDiscriminatorMapping;
    protected String relationDiscriminatorValue;
    protected final DatastoreIdentifier elmIdentifier;
    protected ClassLoaderResolver clr;
    protected final ElementContainerStoreSpecialization specialization;

    protected ElementContainerStore(StoreManager storeMgr, ClassLoaderResolver clr, ElementContainerStoreSpecialization elementContainerStoreSpecialization) {
        super(storeMgr);
        this.clr = clr;
        this.elmIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "ELEMENT");
        this.specialization = elementContainerStoreSpecialization;
    }

    public ElementInfo[] getElementInfo() {
        return this.elementInfo;
    }

    public JavaTypeMapping getElementMapping() {
        return this.elementMapping;
    }

    public JavaTypeMapping getOrderMapping() {
        return this.orderMapping;
    }

    public JavaTypeMapping getRelationDiscriminatorMapping() {
        return this.relationDiscriminatorMapping;
    }

    public String getRelationDiscriminatorValue() {
        return this.relationDiscriminatorValue;
    }

    public DatastoreContainerObject getContainerTable() {
        return this.containerTable;
    }

    public AbstractClassMetaData getEmd() {
        return this.emd;
    }

    public boolean isElementsAreSerialised() {
        return this.elementsAreSerialised;
    }

    public boolean isElementsAreEmbedded() {
        return this.elementsAreEmbedded;
    }

    protected ElementInfo[] getElementInformationForClass() {
        String[] clsNames;
        DatastoreClass tbl;
        ElementInfo[] info = null;
        if (!this.clr.classForName(this.elementType).isInterface()) {
            tbl = this.storeMgr.getDatastoreClass(this.elementType, this.clr);
            clsNames = new String[]{this.elementType};
        } else {
            clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.elementType, this.clr);
            tbl = this.storeMgr.getDatastoreClass(clsNames[0], this.clr);
        }
        if (tbl == null) {
            AbstractClassMetaData[] subclassCmds = this.storeMgr.getClassesManagingTableForClass(this.emd, this.clr);
            info = new ElementInfo[subclassCmds.length];
            for (int i = 0; i < subclassCmds.length; ++i) {
                DatastoreClass table = this.storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), this.clr);
                info[i] = new ElementInfo(subclassCmds[i], table);
            }
        } else {
            info = new ElementInfo[clsNames.length];
            for (int i = 0; i < clsNames.length; ++i) {
                AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(clsNames[i], this.clr);
                DatastoreClass table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), this.clr);
                info[i] = new ElementInfo(cmd, table);
            }
        }
        return info;
    }

    public boolean hasOrderMapping() {
        return this.orderMapping != null;
    }

    public String getElementType() {
        return this.elementType;
    }

    protected boolean validateElementType(ClassLoaderResolver clr, Object element) {
        if (element == null) {
            return true;
        }
        Class primitiveElementClass = ClassUtils.getPrimitiveTypeForType(element.getClass());
        if (primitiveElementClass != null) {
            String elementTypeWrapper = this.elementType;
            Class elementTypeClass = clr.classForName(this.elementType);
            if (elementTypeClass.isPrimitive()) {
                elementTypeWrapper = ClassUtils.getWrapperTypeForPrimitiveType(elementTypeClass).getName();
            }
            return clr.isAssignableFrom(elementTypeWrapper, element.getClass());
        }
        return clr.isAssignableFrom(this.elementType, element.getClass());
    }

    protected boolean validateElementForReading(StateManager sm, Object element) {
        ObjectManager om;
        if (!this.validateElementType(sm.getObjectManager().getClassLoaderResolver(), element)) {
            return false;
        }
        return element == null || this.elementsAreEmbedded || this.elementsAreSerialised || (om = sm.getObjectManager()).getApiAdapter().isPersistent(element) && om == om.getApiAdapter().getObjectManager(element) || om.getApiAdapter().isDetached(element);
    }

    protected boolean validateElementForWriting(StateManager sm, Object element, FieldValues fieldValues) {
        if (!this.elementIsPersistentInterface && !this.validateElementType(sm.getObjectManager().getClassLoaderResolver(), element)) {
            throw new ClassCastException(LOCALISER.msg("056033", (Object)element.getClass().getName(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)this.elementType));
        }
        boolean persisted = false;
        if (!this.elementsAreEmbedded && !this.elementsAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            StateManager elementSM = om.findStateManager(element);
            if (elementSM != null && elementSM.isEmbedded()) {
                throw new NucleusUserException(LOCALISER.msg("056028", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
            }
            persisted = SCOUtils.validateObjectForWriting(om, element, fieldValues);
        }
        return persisted;
    }

    public abstract Iterator iterator(StateManager var1);

    public void clear(StateManager ownerSM) {
        HashSet dependentElements = null;
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement() && !collmd.isSerializedElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        this.specialization.executeClear(ownerSM, this);
        if (dependentElements != null && dependentElements.size() > 0) {
            for (Object obj : dependentElements) {
                if (ownerSM.getObjectManager().getApiAdapter().isDeleted(obj)) continue;
                ownerSM.getObjectManager().deleteObjectInternal(obj);
            }
        }
    }

    public int size(StateManager sm) {
        return this.specialization.getSize(sm, this);
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        JavaTypeMapping verMapping;
        int i;
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            StatementMappingForClass mappingDefinition = new StatementMappingForClass(null);
            if (stmt.hasNucleusTypeExpression()) {
                mappingDefinition.setNucleusTypeColumnName("NUCLEUS_TYPE");
            }
            return this.storeMgr.newResultObjectFactory(null, this.emd, mappingDefinition, ignoreCache, false, null, clr.classForName(this.elementType));
        }
        if (this.elementMapping instanceof ReferenceMapping) {
            JavaTypeMapping[] implMappings = ((ReferenceMapping)this.elementMapping).getJavaTypeMapping();
            for (int i2 = 0; i2 < implMappings.length; ++i2) {
                stmt.select(implMappings[i2]);
            }
            StatementMappingForClass mappingDefinition = new StatementMappingForClass(null);
            if (stmt.hasNucleusTypeExpression()) {
                mappingDefinition.setNucleusTypeColumnName("NUCLEUS_TYPE");
            }
            return this.storeMgr.newResultObjectFactory(this.elementInfo != null ? this.elementInfo[0].getDatastoreClass() : null, this.emd, mappingDefinition, ignoreCache, false, null, clr.classForName(this.elementType));
        }
        StatementMappingIndex[] stmtMappings = null;
        int[] prefetchFieldNumbers = null;
        int[] pkFieldNumbers = null;
        if (this.emd.getIdentityType() == IdentityType.APPLICATION) {
            pkFieldNumbers = new int[this.emd.getPKMemberPositions().length];
            for (int i3 = 0; i3 < pkFieldNumbers.length; ++i3) {
                pkFieldNumbers[i3] = this.emd.getPKMemberPositions()[i3];
            }
        }
        if (useFetchPlan) {
            FetchPlan fp = sm.getObjectManager().getFetchPlan();
            fp.manageFetchPlanForClass(this.emd);
            FetchPlan.FetchPlanForClass fpc = fp.getFetchPlanForClass(this.emd);
            int[] fpFieldNumbers = fpc.getFieldsInActualFetchPlan();
            if (pkFieldNumbers != null) {
                int i4;
                int totalFieldCount = pkFieldNumbers.length + fpFieldNumbers.length;
                for (i = 0; i < pkFieldNumbers.length; ++i) {
                    if (Arrays.binarySearch(fpFieldNumbers, pkFieldNumbers[i]) < 0) continue;
                    --totalFieldCount;
                }
                int prefetchNum = 0;
                prefetchFieldNumbers = new int[totalFieldCount];
                for (i4 = 0; i4 < pkFieldNumbers.length; ++i4) {
                    prefetchFieldNumbers[prefetchNum++] = pkFieldNumbers[i4];
                }
                for (i4 = 0; i4 < fpFieldNumbers.length; ++i4) {
                    if (Arrays.binarySearch(pkFieldNumbers, fpFieldNumbers[i4]) >= 0) continue;
                    prefetchFieldNumbers[prefetchNum++] = fpFieldNumbers[i4];
                }
            } else {
                prefetchFieldNumbers = fpFieldNumbers;
            }
        } else {
            prefetchFieldNumbers = pkFieldNumbers != null ? pkFieldNumbers : new int[]{};
        }
        int[] fn = new int[prefetchFieldNumbers.length];
        int prefetchFieldCount = 0;
        stmtMappings = new StatementMappingIndex[this.emd.getNoOfInheritedManagedMembers() + this.emd.getNoOfManagedMembers()];
        for (int i5 = 0; i5 < prefetchFieldNumbers.length; ++i5) {
            JavaTypeMapping m;
            AbstractMemberMetaData fmd = this.emd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i5]);
            if (fmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || (m = this.elementInfo[0].getDatastoreClass().getMemberMapping(fmd)) == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
            stmtMappings[prefetchFieldNumbers[i5]] = new StatementMappingIndex(m);
            ExpressionHelper.selectMapping(stmtMappings[prefetchFieldNumbers[i5]], stmt, stmt.getTableExpression(this.elmIdentifier) != null ? this.elmIdentifier : null, clr);
            fn[prefetchFieldCount++] = prefetchFieldNumbers[i5];
        }
        int[] fieldNumbers = new int[prefetchFieldCount];
        System.arraycopy(fn, 0, fieldNumbers, 0, prefetchFieldCount);
        StatementMappingForClass mappingDefinition = new StatementMappingForClass(null);
        for (i = 0; i < fieldNumbers.length; ++i) {
            mappingDefinition.addMappingForMember(fieldNumbers[i], stmtMappings[fieldNumbers[i]]);
        }
        if (this.elementInfo[0].getDatastoreClass().getIdentityType() == IdentityType.DATASTORE) {
            int[] datastoreIndex = stmt.select(stmt.getTableExpression(this.elmIdentifier) != null ? this.elmIdentifier : stmt.getMainTableAlias(), this.elementInfo[0].getDatastoreClass().getDataStoreObjectIdMapping(), true);
            StatementMappingIndex datastoreMappingIdx = new StatementMappingIndex(this.elementInfo[0].getDatastoreClass().getDataStoreObjectIdMapping());
            datastoreMappingIdx.setColumnPositions(datastoreIndex);
            mappingDefinition.addMappingForMember(StatementMappingForClass.MEMBER_DATASTORE_ID, datastoreMappingIdx);
        }
        if ((verMapping = this.elementInfo[0].getDatastoreClass().getVersionMapping(true)) != null) {
            int[] versionIndex = stmt.select(stmt.getTableExpression(this.elmIdentifier) != null ? this.elmIdentifier : stmt.getMainTableAlias(), verMapping, true);
            StatementMappingIndex versionMappingIdx = new StatementMappingIndex(verMapping);
            versionMappingIdx.setColumnPositions(versionIndex);
            mappingDefinition.addMappingForMember(StatementMappingForClass.MEMBER_VERSION, versionMappingIdx);
        }
        if (stmt.hasNucleusTypeExpression()) {
            mappingDefinition.setNucleusTypeColumnName("NUCLEUS_TYPE");
        }
        return this.storeMgr.newResultObjectFactory(this.elementInfo != null ? this.elementInfo[0].getDatastoreClass() : null, this.emd, mappingDefinition, ignoreCache, this.iterateUsingDiscriminator, null, clr.classForName(this.elementType));
    }

    public class ElementInfo {
        AbstractClassMetaData cmd;
        DatastoreClass table;

        public ElementInfo(AbstractClassMetaData cmd, DatastoreClass table) {
            this.cmd = cmd;
            this.table = table;
        }

        public String getClassName() {
            return this.cmd.getFullClassName();
        }

        public AbstractClassMetaData getAbstractClassMetaData() {
            return this.cmd;
        }

        public DatastoreClass getDatastoreClass() {
            return this.table;
        }

        public DiscriminatorStrategy getDiscriminatorStrategy() {
            return this.cmd.getDiscriminatorStrategy();
        }

        public JavaTypeMapping getDiscriminatorMapping() {
            return this.table.getDiscriminatorMapping(false);
        }
    }
}

