/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.datanucleus.FetchGroup;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.util.MultiMap;

public class FetchGroupManager {
    private MultiMap fetchGroupByName;
    private OMFContext omfCtx;

    public FetchGroupManager(OMFContext ctx) {
        this.omfCtx = ctx;
    }

    public void addFetchGroup(FetchGroup grp) {
        Collection coll;
        if (this.fetchGroupByName == null) {
            this.fetchGroupByName = new MultiMap();
        }
        if ((coll = (Collection)this.fetchGroupByName.get(grp.getName())) != null) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                FetchGroup existingGrp = (FetchGroup)iter.next();
                if (!existingGrp.getName().equals(grp.getName()) || !existingGrp.getType().getName().equals(grp.getType().getName())) continue;
                existingGrp.disconnectFromListeners();
                iter.remove();
            }
        }
        this.fetchGroupByName.put(grp.getName(), grp);
    }

    public void removeFetchGroup(FetchGroup grp) {
        Collection coll;
        if (this.fetchGroupByName != null && (coll = (Collection)this.fetchGroupByName.get(grp.getName())) != null) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                FetchGroup existingGrp = (FetchGroup)obj;
                if (existingGrp.getType() != grp.getType()) continue;
                existingGrp.disconnectFromListeners();
                iter.remove();
            }
        }
    }

    public FetchGroup getFetchGroup(Class cls, String name) {
        Collection coll;
        if (this.fetchGroupByName != null && (coll = (Collection)this.fetchGroupByName.get(name)) != null) {
            for (FetchGroup grp : coll) {
                if (grp.getType() != cls) continue;
                return grp;
            }
        }
        FetchGroup grp = this.createFetchGroup(cls, name);
        this.addFetchGroup(grp);
        return grp;
    }

    public FetchGroup createFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.omfCtx.getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.omfCtx.getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return new FetchGroup(this.omfCtx, name, cls);
    }

    public Set getFetchGroupsWithName(String name) {
        Collection coll;
        if (this.fetchGroupByName != null && (coll = (Collection)this.fetchGroupByName.get(name)) != null) {
            return new HashSet(coll);
        }
        return null;
    }

    public void clearFetchGroups() {
        if (this.fetchGroupByName != null) {
            Collection fetchGroups = this.fetchGroupByName.values();
            for (FetchGroup grp : fetchGroups) {
                grp.disconnectFromListeners();
            }
            this.fetchGroupByName.clear();
        }
    }
}

