/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.safari.AppleScript;
import org.openqa.selenium.safari.SafariDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafariWebElement
implements WebElement,
SearchContext {
    private final int index;
    private final AppleScript appleScript;
    private final SafariDriver parent;
    private final String locator;

    public SafariWebElement(SafariDriver parent, String elementIndex) {
        this.parent = parent;
        this.index = Integer.parseInt(elementIndex);
        this.locator = "document.webdriverElements[" + this.index + "]";
        this.appleScript = new AppleScript();
    }

    public void click() {
        this.appleScript.executeJavascript("if (" + this.locator + "[\"click\"])" + this.locator + ".click();\r" + "var event = document.createEvent(\"MouseEvents\");\r" + "event.initMouseEvent(\"click\", true, true, null, 1, 0, 0, 0, 0, false, false, false, false, 0, null);" + this.locator + ".dispatchEvent(event);\r");
        this.parent.waitForLoadToComplete();
    }

    public void submit() {
        throw new UnsupportedOperationException("submit");
    }

    public String getValue() {
        return this.appleScript.executeJavascript("if (" + this.locator + "[\"value\"] !== undefined)\r" + "  return " + this.locator + ".value;\r" + "if (" + this.locator + ".hasAttribute(\"value\"))\r" + "  " + this.locator + ".getAttribute(\"value\");\r");
    }

    public void sendKeys(CharSequence ... value) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence seq : value) {
            builder.append(seq);
        }
        this.appleScript.executeJavascript(this.locator + ".focus()");
        this.appleScript.executeApplescript("tell application \"System Events\"\r    keystroke (\"" + builder.toString() + "\")\r" + "end tell");
        this.appleScript.executeJavascript(this.locator + ".blur()");
    }

    public void clear() {
        this.appleScript.executeJavascript("if (" + this.locator + "['value']) { " + this.locator + ".value = ''; }\r" + "else { " + this.locator + ".setAttribute('value', ''); }");
    }

    public String getElementName() {
        throw new UnsupportedOperationException("getElementName");
    }

    public String getAttribute(String name) {
        throw new UnsupportedOperationException("getAttribute");
    }

    public boolean toggle() {
        throw new UnsupportedOperationException("toggle");
    }

    public boolean isSelected() {
        throw new UnsupportedOperationException("isSelected");
    }

    public void setSelected() {
        throw new UnsupportedOperationException("setSelected");
    }

    public boolean isEnabled() {
        throw new UnsupportedOperationException("isEnabled");
    }

    public String getText() {
        return this.appleScript.executeJavascript("return " + this.locator + ".innerText");
    }

    public List<WebElement> getElementsByTagName(String tagName) {
        throw new UnsupportedOperationException("getElementsByTagName");
    }

    public WebElement findElement(By by) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public List<WebElement> findElements(By by) {
        throw new UnsupportedOperationException("To be implemented");
    }
}

