/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.jetty;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.jetty.AppEngineAuthentication;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.webapp.WebAppContext;

public class AppEngineWebAppContext
extends WebAppContext {
    private final String serverInfo;

    public AppEngineWebAppContext(File appDir, String serverInfo) {
        super(appDir.getPath(), "/");
        this.serverInfo = serverInfo;
        this._scontext = new AppEngineServletContext();
        AppEngineAuthentication.configureSecurityHandler(this.getSecurityHandler());
    }

    public class AppEngineServletContext
    extends Context.SContext {
        public AppEngineServletContext() {
            super(AppEngineWebAppContext.this);
        }

        public String getServerInfo() {
            return AppEngineWebAppContext.this.serverInfo;
        }

        public void log(String message) {
            this.log(message, null);
        }

        public void log(String message, Throwable throwable) {
            StringWriter writer = new StringWriter();
            writer.append("javax.servlet.ServletContext log: ");
            writer.append(message);
            if (throwable != null) {
                writer.append("\n");
                throwable.printStackTrace(new PrintWriter(writer));
            }
            ApiProxy.LogRecord.Level logLevel = throwable == null ? ApiProxy.LogRecord.Level.info : ApiProxy.LogRecord.Level.error;
            ApiProxy.log((ApiProxy.LogRecord)new ApiProxy.LogRecord(logLevel, System.currentTimeMillis() * 1000L, writer.toString()));
        }

        public void log(Exception exception, String msg) {
            this.log(msg, exception);
        }
    }
}

