/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerClassLoader;
import com.google.apphosting.utils.security.SecurityManagerInstaller;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.PropertyPermission;

public class DevAppServerFactory {
    private static final String DEV_APP_SERVER_CLASS = "com.google.appengine.tools.development.DevAppServerImpl";

    public DevAppServer createDevAppServer(File appLocation, String address, int port) {
        SecurityManagerInstaller.install(new URL[0]);
        System.setSecurityManager(new CustomSecurityManager());
        DevAppServerClassLoader loader = DevAppServerClassLoader.newClassLoader(DevAppServerFactory.class.getClassLoader());
        try {
            Class<?> devAppServerClass = Class.forName(DEV_APP_SERVER_CLASS, true, loader);
            Constructor<?> cons = devAppServerClass.getConstructor(File.class, String.class, Integer.TYPE);
            cons.setAccessible(true);
            return (DevAppServer)cons.newInstance(appLocation, address, port);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException) {
                t = ((InvocationTargetException)e).getCause();
            }
            throw new RuntimeException("Unable to create a DevAppServer", t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivilegedIsDevAppServerThread
    implements PrivilegedAction<Boolean> {
        private PrivilegedIsDevAppServerThread() {
        }

        @Override
        public Boolean run() {
            return Boolean.getBoolean("devappserver-thread-" + Thread.currentThread().getName());
        }
    }

    private static class CustomSecurityManager
    extends SecurityManager {
        private static final RuntimePermission PERMISSION_MODIFY_THREAD_GROUP = new RuntimePermission("modifyThreadGroup");
        private static final RuntimePermission PERMISSION_MODIFY_THREAD = new RuntimePermission("modifyThread");

        private CustomSecurityManager() {
        }

        public void checkPermission(Permission perm) {
            if (perm instanceof PropertyPermission) {
                return;
            }
            if (this.isDevAppServerThread()) {
                super.checkPermission(perm);
            }
        }

        public void checkPermission(Permission perm, Object context) {
            if (this.isDevAppServerThread()) {
                super.checkPermission(perm, context);
            }
        }

        public void checkAccess(ThreadGroup g) {
            if (g == null) {
                throw new NullPointerException("thread group can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD_GROUP);
        }

        public void checkAccess(Thread t) {
            if (t == null) {
                throw new NullPointerException("thread can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD);
        }

        public boolean isDevAppServerThread() {
            return Boolean.getBoolean("devappserver-thread-" + Thread.currentThread().getName());
        }
    }
}

