/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.RotatingLogStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class RotatingDateLogStream
extends RotatingLogStream {
    private Calendar lastDate_;
    private Calendar currentDate_;

    public RotatingDateLogStream(String basename, String linkname, DateFormat dateFormat) throws IOException {
        super(basename, linkname, dateFormat);
    }

    protected String getNextFilename() {
        this.setLastDate(new Date());
        return super.getNextFilename();
    }

    protected void checkRotate(int lenToWrite) throws IOException {
        this.setCurrentDate(new Date());
        int curDate = this.currentDate_.get(5);
        int lastDate = this.lastDate_.get(5);
        if (curDate != lastDate) {
            this.rotate();
        }
        super.checkRotate(lenToWrite);
    }

    protected void setLastDate(Date date) {
        if (this.lastDate_ == null) {
            this.lastDate_ = Calendar.getInstance();
        }
        this.lastDate_.setTime(date);
    }

    private void setCurrentDate(Date date) {
        if (this.currentDate_ == null) {
            this.currentDate_ = Calendar.getInstance();
        }
        this.currentDate_.setTime(date);
    }
}

