/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import com.sun.net.ssl.X509TrustManager;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSSLX509TrustManager
implements X509TrustManager {
    private X509TrustManager defaultTrustManager = null;
    private static final Log LOG = LogFactory.getLog(AuthSSLX509TrustManager.class);

    public AuthSSLX509TrustManager(X509TrustManager x509TrustManager) {
        if (x509TrustManager == null) {
            throw new IllegalArgumentException("Trust manager may not be null");
        }
        this.defaultTrustManager = x509TrustManager;
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
        if (LOG.isInfoEnabled() && x509CertificateArray != null) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                X509Certificate x509Certificate = x509CertificateArray[i];
                LOG.info(" Client certificate " + (i + 1) + ":");
                LOG.info("  Subject DN: " + x509Certificate.getSubjectDN());
                LOG.info("  Signature Algorithm: " + x509Certificate.getSigAlgName());
                LOG.info("  Valid from: " + x509Certificate.getNotBefore());
                LOG.info("  Valid until: " + x509Certificate.getNotAfter());
                LOG.info("  Issuer: " + x509Certificate.getIssuerDN());
            }
        }
        return this.defaultTrustManager.isClientTrusted(x509CertificateArray);
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
        if (LOG.isInfoEnabled() && x509CertificateArray != null) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                X509Certificate x509Certificate = x509CertificateArray[i];
                LOG.info(" Server certificate " + (i + 1) + ":");
                LOG.info("  Subject DN: " + x509Certificate.getSubjectDN());
                LOG.info("  Signature Algorithm: " + x509Certificate.getSigAlgName());
                LOG.info("  Valid from: " + x509Certificate.getNotBefore());
                LOG.info("  Valid until: " + x509Certificate.getNotAfter());
                LOG.info("  Issuer: " + x509Certificate.getIssuerDN());
            }
        }
        return this.defaultTrustManager.isServerTrusted(x509CertificateArray);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

