/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.Entity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.AbstractIterator;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StreamingQueryResult
extends AbstractQueryResult {
    private final Utils.Function<Entity, Object> entityToPojoFunc;
    private final Iterator<Entity> lazyEntityIterator;
    private final ArrayList<Object> resolvedPojos = Utils.newArrayList(new Object[0]);

    public StreamingQueryResult(Query query, Iterable<Entity> lazyEntities, Utils.Function<Entity, Object> entityToPojoFunc) {
        super(query);
        this.lazyEntityIterator = lazyEntities.iterator();
        this.entityToPojoFunc = entityToPojoFunc;
    }

    protected void closingConnection() {
    }

    protected void closeResults() {
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public Object get(int index) {
        if (index >= this.resolvedPojos.size() && this.lazyEntityIterator.hasNext()) {
            for (int i = this.resolvedPojos.size(); i <= index && this.lazyEntityIterator.hasNext(); ++i) {
                this.resolveNext();
            }
        }
        return this.resolvedPojos.get(index);
    }

    void resolveNext() {
        this.resolvedPojos.add(this.entityToPojoFunc.apply(this.lazyEntityIterator.next()));
    }

    public Iterator<?> iterator() {
        return this.listIterator();
    }

    public ListIterator<?> listIterator() {
        if (!this.lazyEntityIterator.hasNext()) {
            return this.resolvedPojos.listIterator();
        }
        return new AbstractListIterator(){
            private int curIndex = 0;

            protected Object computeNext() {
                if (this.curIndex >= StreamingQueryResult.this.resolvedPojos.size()) {
                    if (!StreamingQueryResult.this.lazyEntityIterator.hasNext()) {
                        this.endOfData();
                        return null;
                    }
                    StreamingQueryResult.this.resolveNext();
                }
                return StreamingQueryResult.this.resolvedPojos.get(this.curIndex++);
            }
        };
    }

    public int size() {
        while (this.lazyEntityIterator.hasNext()) {
            this.resolveNext();
        }
        return this.resolvedPojos.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractListIterator
    extends AbstractIterator<Object>
    implements ListIterator<Object> {
        private int curIndex = 0;
        private int maxIndex = 0;

        private AbstractListIterator() {
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() != -1;
        }

        @Override
        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object result = StreamingQueryResult.this.resolvedPojos.get(this.previousIndex());
            --this.curIndex;
            return result;
        }

        @Override
        public int nextIndex() {
            return this.curIndex;
        }

        @Override
        public int previousIndex() {
            return this.curIndex - 1;
        }

        @Override
        public boolean hasNext() {
            return this.curIndex < this.maxIndex || super.hasNext();
        }

        @Override
        public Object next() {
            if (this.curIndex < this.maxIndex) {
                return StreamingQueryResult.this.resolvedPojos.get(this.curIndex++);
            }
            Object result = super.next();
            this.maxIndex = ++this.curIndex;
            return result;
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

