/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.base.HashBase;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongSet
implements Iterable<Long> {
    private static final long EMPTY_KEY = -1L;
    private static final long DELETED_KEY = -2L;
    private long[] table;
    private int count;
    private int bits1;
    private int bits2;
    private int enlarge_threshold;
    private int lookups;
    private int probes;
    private int deleted;
    private int shrink_threshold;
    private static final float MAX_OCCUPANCY = 0.8f;
    private static final float MIN_OCCUPANCY = 0.1f;
    private static long[] empty_table = new long[0];
    private long last_stats = System.currentTimeMillis();
    private final boolean silent_;

    public LongSet() {
        this(4);
    }

    public LongSet(int n) {
        this(n, false);
    }

    public LongSet(int n, boolean silent) {
        this.silent_ = silent;
        this.table = empty_table;
        this.resize(Math.max(3, n));
    }

    public void insert(long key) {
        int index = this.find_index(key);
        long old_elem = this.table[index];
        this.table[index] = key;
        if (old_elem == -1L) {
            ++this.count;
            if (this.count + this.deleted >= this.enlarge_threshold) {
                this.resize(this.count * 2);
            }
        } else if (old_elem == -2L) {
            ++this.count;
            --this.deleted;
        }
    }

    public boolean contains(long key) {
        long elem = this.table[this.find_index(key)];
        return elem != -1L && elem != -2L;
    }

    public boolean remove(long key) {
        int index = this.find_index(key);
        long elem = this.table[index];
        if (elem == -1L || elem == -2L) {
            return false;
        }
        this.table[index] = -2L;
        --this.count;
        ++this.deleted;
        if (this.count < this.shrink_threshold) {
            this.resize(this.count);
        }
        return true;
    }

    public int size() {
        return this.count;
    }

    public int next(int i) {
        ++i;
        while (i < this.table.length) {
            long key = this.table[i];
            if (key != -1L && key != -2L) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Iterator<Long> iterator() {
        return new HashIterator<Long>(this){

            @Override
            public Long next() {
                return this.map.keyAt(this.nextIndex());
            }
        };
    }

    public long[] toArray() {
        long[] array = new long[this.size()];
        int arrayIndex = 0;
        int mapIndex = -1;
        while ((mapIndex = this.next(mapIndex)) >= 0 && arrayIndex < array.length) {
            array[arrayIndex++] = this.keyAt(mapIndex);
        }
        return array;
    }

    public long keyAt(int i) {
        return this.table[i];
    }

    public void removeAt(int i) {
        X.assertTrue(this.table[i] != -2L);
        X.assertTrue(this.table[i] != -1L);
        this.table[i] = -2L;
        --this.count;
        ++this.deleted;
    }

    private int find_index(long key) {
        ++this.lookups;
        int n = this.table.length;
        int mult = HashBase.hash(key) * -820265764 & Integer.MAX_VALUE;
        int h1 = mult >>> this.bits1 & n - 1;
        int h2 = mult >>> this.bits2 & n - 1 | 1;
        int index = h1;
        int deleted_index = -1;
        for (int i = 0; i < n; ++i) {
            ++this.probes;
            if (this.table[index] == -2L) {
                if (deleted_index < 0) {
                    deleted_index = index;
                }
            } else {
                if (this.table[index] == -1L) {
                    return deleted_index >= 0 ? deleted_index : index;
                }
                if (key == this.table[index]) {
                    return index;
                }
            }
            index = index + h2 & n - 1;
        }
        throw new RuntimeException("Did not find empty slot for " + key);
    }

    public void resize(int desired) {
        int i;
        if (desired < this.count) {
            desired = this.count;
        }
        int min_size = (int)((float)desired / 0.8f);
        int lg = 2;
        while (1 << lg < min_size) {
            ++lg;
        }
        int n = 1 << lg;
        if (n == this.count) {
            return;
        }
        long[] old = this.table;
        this.table = new long[n];
        this.enlarge_threshold = Math.min(n - 1, (int)((float)n * 0.8f));
        X.assertTrue(this.enlarge_threshold < n);
        this.count = 0;
        this.bits2 = Math.max(31 - 2 * lg, 0);
        this.bits1 = 31 - lg;
        this.shrink_threshold = (int)((float)n * 0.1f);
        if (this.shrink_threshold <= 10) {
            this.shrink_threshold = 1;
        }
        this.deleted = 0;
        X.assertTrue(this.shrink_threshold < this.enlarge_threshold);
        X.assertTrue(this.shrink_threshold >= 0);
        for (i = 0; i < n; ++i) {
            this.table[i] = -1L;
        }
        for (i = 0; i < old.length; ++i) {
            long elem = old[i];
            if (elem == -1L || elem == -2L) continue;
            this.insert(elem);
        }
        if (!(this.table.length < 131072 && old.length < 131072 || this.silent_)) {
            this.stats("resize");
        }
    }

    public void stats(String label) {
        long now = System.currentTimeMillis();
        System.err.println((double)(now - this.last_stats) / 1000.0 + " " + label + " " + this.count + " cnt; " + this.table.length + " sz; " + this.enlarge_threshold + " th; " + this.lookups + "/" + this.probes);
        this.last_stats = now;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class HashIterator<E>
    implements Iterator<E> {
        private int nextIndex;
        private int currentIndex;
        LongSet map;

        private HashIterator(LongSet map) {
            this.map = map;
            this.nextIndex = map.next(-1);
            this.currentIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        int nextIndex() {
            this.currentIndex = this.nextIndex;
            this.nextIndex = this.map.next(this.currentIndex);
            return this.currentIndex;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException();
            }
            this.map.removeAt(this.currentIndex);
            this.nextIndex = this.map.next(this.currentIndex);
            this.currentIndex = -1;
        }
    }
}

