/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.LogAndContinueErrorHandler;
import com.google.appengine.api.memcache.MemcacheSerialization;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.MemcacheServicePb;
import com.google.appengine.api.memcache.Stats;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemcacheServiceImpl
implements MemcacheService {
    static final String PACKAGE = "memcache";
    private static final Logger logger = Logger.getLogger(MemcacheServiceImpl.class.getName());
    private ErrorHandler handler = new LogAndContinueErrorHandler(Level.INFO);
    private String namespace;

    MemcacheServiceImpl() {
        this.setNamespace(null);
    }

    private boolean makeSyncCall(String methodName, ProtocolMessage request, ProtocolMessage response, String errorText) {
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, methodName, request.toByteArray());
            response.mergeFrom(responseBytes);
            return true;
        }
        catch (ApiProxy.ApplicationException ae) {
            logger.info(errorText + ": " + ae.getErrorDetail());
            this.handler.handleServiceError(new MemcacheServiceException(errorText));
        }
        catch (ApiProxy.ApiProxyException ex) {
            this.handler.handleServiceError(new MemcacheServiceException(errorText, ex));
        }
        return false;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String newNamespace) {
        this.namespace = newNamespace == null ? NamespaceManager.get() : newNamespace;
    }

    @Override
    public boolean contains(Object key) {
        MemcacheServicePb.MemcacheGetRequest request = new MemcacheServicePb.MemcacheGetRequest();
        MemcacheServicePb.MemcacheGetResponse response = new MemcacheServicePb.MemcacheGetResponse();
        request.setNameSpace(this.getNamespace());
        try {
            request.addKeyAsBytes(MemcacheSerialization.makePbKey(key));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
        }
        if (!this.makeSyncCall("Get", request, response, "Memcache contains: exception testing contains (" + key + ")")) {
            return false;
        }
        return response.itemSize() == 1;
    }

    @Override
    public Object get(Object key) {
        MemcacheServicePb.MemcacheGetRequest request = new MemcacheServicePb.MemcacheGetRequest();
        MemcacheServicePb.MemcacheGetResponse response = new MemcacheServicePb.MemcacheGetResponse();
        request.setNameSpace(this.getNamespace());
        try {
            request.addKeyAsBytes(MemcacheSerialization.makePbKey(key));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as a key: '" + key + "'", ex);
        }
        if (!this.makeSyncCall("Get", request, response, "Memcache get: exception getting 1 key (" + key + ")")) {
            return null;
        }
        if (response.itemSize() == 0) {
            return null;
        }
        MemcacheServicePb.MemcacheGetResponse.Item item = response.getItem(0);
        try {
            return MemcacheSerialization.deserialize(item.getValueAsBytes(), item.getFlags());
        }
        catch (ClassNotFoundException ex) {
            this.handler.handleDeserializationError(new InvalidValueException("Can't find class for value of key '" + key + "'", ex));
            return null;
        }
        catch (IOException ex) {
            throw new InvalidValueException("IO exception parsing value of '" + key + "'", ex);
        }
    }

    @Override
    public Map<Object, Object> getAll(Collection<Object> keys) {
        MemcacheServicePb.MemcacheGetRequest request = new MemcacheServicePb.MemcacheGetRequest();
        MemcacheServicePb.MemcacheGetResponse response = new MemcacheServicePb.MemcacheGetResponse();
        request.setNameSpace(this.getNamespace());
        HashMap<CacheKey, Object> cacheKeyToObjectKey = new HashMap<CacheKey, Object>();
        for (Object key : keys) {
            try {
                byte[] keybytes = MemcacheSerialization.makePbKey(key);
                cacheKeyToObjectKey.put(new CacheKey(keybytes), key);
                request.addKeyAsBytes(keybytes);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
            }
        }
        if (!this.makeSyncCall("Get", request, response, "Memcache get: exception getting multiple keys")) {
            return new HashMap<Object, Object>();
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (MemcacheServicePb.MemcacheGetResponse.Item item : response.items()) {
            Object key = null;
            try {
                key = cacheKeyToObjectKey.get(new CacheKey(item.getKeyAsBytes()));
                Object obj = MemcacheSerialization.deserialize(item.getValueAsBytes(), item.getFlags());
                result.put(key, obj);
            }
            catch (ClassNotFoundException ex) {
                this.handler.handleDeserializationError(new InvalidValueException("Can't find class for value of key '" + key + "'", ex));
                return null;
            }
            catch (IOException ex) {
                throw new InvalidValueException("IO exception parsing value of '" + key + "'", ex);
            }
        }
        return result;
    }

    @Override
    public boolean put(Object key, Object value, Expiration expires, MemcacheService.SetPolicy policy) {
        MemcacheServicePb.MemcacheSetRequest request = new MemcacheServicePb.MemcacheSetRequest();
        MemcacheServicePb.MemcacheSetResponse response = new MemcacheServicePb.MemcacheSetResponse();
        request.setNameSpace(this.getNamespace());
        MemcacheServicePb.MemcacheSetRequest.Item item = new MemcacheServicePb.MemcacheSetRequest.Item();
        try {
            MemcacheSerialization.ValueAndFlags vaf = MemcacheSerialization.serialize(value);
            item.setValueAsBytes(vaf.value);
            item.setFlags(vaf.flags.ordinal());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as value: '" + value + "'", ex);
        }
        try {
            item.setKeyAsBytes(MemcacheSerialization.makePbKey(key));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
        }
        item.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
        item.setSetPolicy(policy.ordinal() + 1);
        request.addItem(item);
        if (!this.makeSyncCall("Set", request, response, "Memcache put: exception setting 1 key (" + key + ") to '" + value + "'")) {
            return false;
        }
        if (response.setStatusSize() != 1) {
            throw new MemcacheServiceException("Memcache put: Set one item, got " + response.setStatusSize() + " response statuses");
        }
        int status = response.getSetStatus(0);
        if (status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.ERROR.getValue()) {
            throw new MemcacheServiceException("Memcache put: Error setting single item (" + key + ")");
        }
        return status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED.getValue();
    }

    @Override
    public void put(Object key, Object value, Expiration expires) {
        this.put(key, value, expires, MemcacheService.SetPolicy.SET_ALWAYS);
    }

    @Override
    public void put(Object key, Object value) {
        this.put(key, value, null, MemcacheService.SetPolicy.SET_ALWAYS);
    }

    @Override
    public Set<Object> putAll(Map<Object, Object> values, Expiration expires, MemcacheService.SetPolicy policy) {
        MemcacheServicePb.MemcacheSetRequest request = new MemcacheServicePb.MemcacheSetRequest();
        MemcacheServicePb.MemcacheSetResponse response = new MemcacheServicePb.MemcacheSetResponse();
        request.setNameSpace(this.getNamespace());
        HashMap<CacheKey, Object> cacheKeyToObjectKey = new HashMap<CacheKey, Object>();
        for (Map.Entry<Object, Object> entry : values.entrySet()) {
            MemcacheServicePb.MemcacheSetRequest.Item item = new MemcacheServicePb.MemcacheSetRequest.Item();
            try {
                MemcacheSerialization.ValueAndFlags vaf = MemcacheSerialization.serialize(entry.getValue());
                item.setValueAsBytes(vaf.value);
                item.setFlags(vaf.flags.ordinal());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot use as value: '" + entry.getValue() + "'", ex);
            }
            try {
                byte[] sha1 = MemcacheSerialization.makePbKey(entry.getKey());
                cacheKeyToObjectKey.put(new CacheKey(sha1), entry.getKey());
                item.setKeyAsBytes(sha1);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot use as key: '" + entry.getKey() + "'", ex);
            }
            item.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
            item.setSetPolicy(policy.ordinal() + 1);
            request.addItem(item);
        }
        if (!this.makeSyncCall("Set", request, response, "Memcache put: Unknown exception setting " + values.size() + " keys")) {
            return new HashSet<Object>();
        }
        HashSet<Object> result = new HashSet<Object>();
        HashSet<String> errors = new HashSet<String>();
        if (response.setStatusSize() != values.size()) {
            throw new MemcacheServiceException("Memcache put: Set " + values.size() + " items, got " + response.setStatusSize() + " response statuses");
        }
        for (int i = 0; i < values.size(); ++i) {
            int status = response.getSetStatus(i);
            if (status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.ERROR.getValue()) {
                errors.add(request.getItem(i).getKey());
                continue;
            }
            if (status != MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED.getValue()) continue;
            result.add(cacheKeyToObjectKey.get(new CacheKey(request.getItem(i).getKeyAsBytes())));
        }
        if (errors.size() != 0) {
            StringBuilder builder = new StringBuilder();
            for (Object e : errors) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(e);
            }
            throw new MemcacheServiceException("Memcache put: Set failed to set " + errors.size() + " keys: " + builder.toString());
        }
        return result;
    }

    @Override
    public void putAll(Map<Object, Object> values, Expiration expires) {
        this.putAll(values, expires, MemcacheService.SetPolicy.SET_ALWAYS);
    }

    @Override
    public void putAll(Map<Object, Object> values) {
        this.putAll(values, null, MemcacheService.SetPolicy.SET_ALWAYS);
    }

    @Override
    public boolean delete(Object key) {
        return this.delete(key, 0L);
    }

    @Override
    public boolean delete(Object key, long millisNoReAdd) {
        MemcacheServicePb.MemcacheDeleteRequest request = new MemcacheServicePb.MemcacheDeleteRequest();
        MemcacheServicePb.MemcacheDeleteResponse response = new MemcacheServicePb.MemcacheDeleteResponse();
        request.setNameSpace(this.getNamespace());
        MemcacheServicePb.MemcacheDeleteRequest.Item item = request.addItem();
        try {
            item.setKeyAsBytes(MemcacheSerialization.makePbKey(key));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
        }
        item.setDeleteTime((int)(millisNoReAdd / 1000L));
        if (!this.makeSyncCall("Delete", request, response, "Memcache delete: Unknown exception deleting key: " + key)) {
            return false;
        }
        return response.getDeleteStatus(0) == MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED.getValue();
    }

    @Override
    public Set<Object> deleteAll(Collection<Object> keys) {
        return this.deleteAll(keys, 0L);
    }

    @Override
    public Set<Object> deleteAll(Collection<Object> keys, long millisNoReAdd) {
        HashMap<CacheKey, Object> cacheKeyToObjectKey = new HashMap<CacheKey, Object>();
        MemcacheServicePb.MemcacheDeleteRequest request = new MemcacheServicePb.MemcacheDeleteRequest();
        MemcacheServicePb.MemcacheDeleteResponse response = new MemcacheServicePb.MemcacheDeleteResponse();
        request.setNameSpace(this.getNamespace());
        for (Object key : keys) {
            MemcacheServicePb.MemcacheDeleteRequest.Item item = request.addItem();
            try {
                byte[] sha1 = MemcacheSerialization.makePbKey(key);
                cacheKeyToObjectKey.put(new CacheKey(sha1), key);
                item.setKeyAsBytes(sha1);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
            }
            item.setDeleteTime((int)(millisNoReAdd / 1000L));
        }
        if (!this.makeSyncCall("Delete", request, response, "Memcache delete: Unknown exception deleting multiple keys")) {
            return new HashSet<Object>();
        }
        HashSet<Object> retval = new HashSet<Object>();
        for (int i = 0; i < response.deleteStatusSize(); ++i) {
            if (response.getDeleteStatus(i) != MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED.getValue()) continue;
            retval.add(cacheKeyToObjectKey.get(new CacheKey(request.getItem(i).getKeyAsBytes())));
        }
        return retval;
    }

    @Override
    public Long increment(Object key, long delta) {
        MemcacheServicePb.MemcacheIncrementRequest request = new MemcacheServicePb.MemcacheIncrementRequest();
        MemcacheServicePb.MemcacheIncrementResponse response = new MemcacheServicePb.MemcacheIncrementResponse();
        request.setNameSpace(this.getNamespace());
        try {
            request.setKeyAsBytes(MemcacheSerialization.makePbKey(key));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as key: '" + key + "'", ex);
        }
        if (delta > 0L) {
            request.setDirection(MemcacheServicePb.MemcacheIncrementRequest.Direction.INCREMENT);
            request.setDelta(delta);
        } else {
            request.setDirection(MemcacheServicePb.MemcacheIncrementRequest.Direction.DECREMENT);
            request.setDelta(-delta);
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Increment", request.toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            logger.info(ex.getErrorDetail());
            throw new InvalidValueException("Non-incrementable value for key '" + key + "'");
        }
        catch (ApiProxy.ApiProxyException ex) {
            this.handler.handleServiceError(new MemcacheServiceException("Memcache increment of key '" + key + "': exception", ex));
        }
        if (!response.hasNewValue()) {
            return null;
        }
        return response.getNewValue();
    }

    @Override
    public void clearAll() {
        MemcacheServicePb.MemcacheFlushRequest request = new MemcacheServicePb.MemcacheFlushRequest();
        MemcacheServicePb.MemcacheFlushResponse response = new MemcacheServicePb.MemcacheFlushResponse();
        this.makeSyncCall("FlushAll", request, response, "Memcache flush: exception");
    }

    @Override
    public Stats getStatistics() {
        MemcacheServicePb.MemcacheStatsRequest request = new MemcacheServicePb.MemcacheStatsRequest();
        MemcacheServicePb.MemcacheStatsResponse response = new MemcacheServicePb.MemcacheStatsResponse();
        if (!this.makeSyncCall("Stats", request, response, "Memcache getStatistics: exception")) {
            return null;
        }
        MemcacheServicePb.MergedNamespaceStats stats = response.getStats();
        if (stats == null) {
            return null;
        }
        return new StatsImpl(stats.getHits(), stats.getMisses(), stats.getByteHits(), stats.getItems(), stats.getBytes(), stats.getOldestItemAge());
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler newHandler) {
        this.handler = newHandler;
    }

    private class StatsImpl
    implements Stats {
        private long hits;
        private long misses;
        private long bytesFetched;
        private long items;
        private long bytesStored;
        private int maxCachedTime;

        private StatsImpl(long hits, long misses, long bytesFetched, long items, long bytesStored, int maxCachedTime) {
            this.hits = hits;
            this.misses = misses;
            this.bytesFetched = bytesFetched;
            this.items = items;
            this.bytesStored = bytesStored;
            this.maxCachedTime = maxCachedTime;
        }

        public long getHitCount() {
            return this.hits;
        }

        public long getMissCount() {
            return this.misses;
        }

        public long getBytesReturnedForHits() {
            return this.bytesFetched;
        }

        public long getItemCount() {
            return this.items;
        }

        public long getTotalItemBytes() {
            return this.bytesStored;
        }

        public int getMaxTimeWithoutAccess() {
            return this.maxCachedTime;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Hits: " + this.hits + "\n");
            builder.append("Misses: " + this.misses + "\n");
            builder.append("Bytes Fetched: " + this.bytesFetched + "\n");
            builder.append("Bytes Stored: " + this.bytesStored + "\n");
            builder.append("Items: " + this.items + "\n");
            builder.append("Max Cached Time: " + this.maxCachedTime + "\n");
            return builder.toString();
        }
    }

    private class CacheKey {
        private byte[] keyval;
        private int hashcode;

        public CacheKey(byte[] bytes) {
            this.keyval = bytes;
            this.hashcode = Arrays.hashCode(this.keyval);
        }

        public byte[] getBytes() {
            return this.keyval;
        }

        public boolean equals(Object other) {
            if (other instanceof CacheKey) {
                return Arrays.equals(this.keyval, ((CacheKey)other).keyval);
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

