/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail;

import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.apphosting.api.ApiBasePb;
import com.google.net.rpc.DefaultStubCreationFilter;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcCallback;
import com.google.net.rpc.RpcCancelCallback;
import com.google.net.rpc.RpcException;
import com.google.net.rpc.RpcInterface;
import com.google.net.rpc.RpcServerParameters;
import com.google.net.rpc.RpcService;
import com.google.net.rpc.RpcStub;
import com.google.net.rpc.RpcStubFactory;
import com.google.net.rpc.RpcStubParameters;
import com.google.net.rpc.StubCreationFilter;
import com.google.net.rpc.impl.ApplicationHandler;
import com.google.net.rpc.impl.BlockingApplicationHandler;
import com.google.net.rpc.impl.RpcHandlerRegistry;
import com.google.net.rpc.impl.RpcServerConfig;
import com.google.net.ssl.SslSecurityLevel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class MailServicePb {
    private MailServicePb() {
    }

    public static final class MailService {
        private static volatile StubCreationFilter stubCreationFilter_ = new DefaultStubCreationFilter();
        private static final RpcStubFactory stubFactory_ = new RpcStubFactory(){

            public RpcStub newRpcStub(RpcStubParameters params) {
                return new SimpleStub(stubCreationFilter_.filterStubParameters("MailService", params));
            }
        };

        private MailService() {
        }

        public static void setStubCreationFilter(StubCreationFilter filter) {
            stubCreationFilter_ = filter == null ? new DefaultStubCreationFilter() : filter;
        }

        public static RpcStubFactory stubFactory() {
            return stubFactory_;
        }

        public static BlockingStub newBlockingStub(RpcStubParameters params) {
            return new BlockingStub(stubCreationFilter_.filterStubParameters("MailService", params));
        }

        public static Stub newStub(RpcStubParameters params) {
            return new Stub(stubCreationFilter_.filterStubParameters("MailService", params));
        }

        public static ServerConfig exportService(Interface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            MailService.exportServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportServiceUsingConfig(final Interface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Send", (ProtocolMessage)new MailMessage(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.Send_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.send(rpc, (MailMessage)rpc.internalRequest(), (ApiBasePb.VoidProto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "SendToAdmins", (ProtocolMessage)new MailMessage(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.SendToAdmins_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.sendToAdmins(rpc, (MailMessage)rpc.internalRequest(), (ApiBasePb.VoidProto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
        }

        public static RpcService newService(final Interface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return MailService.exportService(impl, registry);
                }
            };
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            MailService.exportBlockingServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(final BlockingInterface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Send", (ProtocolMessage)new MailMessage(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.Send_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.VoidProto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.send(rpc, (MailMessage)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "SendToAdmins", (ProtocolMessage)new MailMessage(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.SendToAdmins_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.VoidProto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.sendToAdmins(rpc, (MailMessage)rpc.internalRequest());
                }
            });
        }

        public static RpcService newBlockingService(final BlockingInterface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return MailService.exportBlockingService(impl, registry);
                }
            };
        }

        public static void unexport(RpcHandlerRegistry registry) {
            registry.unregisterService("MailService");
        }

        public static class ServerConfig
        extends RpcServerConfig {
            final RpcServerParameters Send_parameters_ = new RpcServerParameters();
            final RpcServerParameters SendToAdmins_parameters_ = new RpcServerParameters();

            public ServerConfig() {
                this("MailService");
            }

            public ServerConfig(String serviceName) {
                super(serviceName);
            }

            public void setRpcRunner(Executor t) {
                this.setRpcRunner_Send(t);
                this.setRpcRunner_SendToAdmins(t);
            }

            public void setRpcRunner_Send(Executor t) {
                this.Send_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_SendToAdmins(Executor t) {
                this.SendToAdmins_parameters_.setRpcRunner(t);
            }

            public void setServerLogging_Send(int t) {
                this.Send_parameters_.setServerLogging(t);
            }

            public void setServerLogging_SendToAdmins(int t) {
                this.SendToAdmins_parameters_.setServerLogging(t);
            }

            public void setSecurityLevel_Send(SslSecurityLevel t) {
                this.Send_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_SendToAdmins(SslSecurityLevel t) {
                this.SendToAdmins_parameters_.setSecurityLevel(t);
            }

            public void setRpcCancelCallback_Send(RpcCancelCallback t) {
                this.Send_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_SendToAdmins(RpcCancelCallback t) {
                this.SendToAdmins_parameters_.setRpcCancelCallback(t);
            }
        }

        public static class Stub
        extends BlockingStub
        implements Interface {
            Stub(RpcStubParameters params) {
                super(params);
            }

            public void send(RPC rpc, MailMessage req, ApiBasePb.VoidProto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Send_method_, "Send", req, reply, cb, this.Send_parameters_);
            }

            public void sendToAdmins(RPC rpc, MailMessage req, ApiBasePb.VoidProto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.SendToAdmins_method_, "SendToAdmins", req, reply, cb, this.SendToAdmins_parameters_);
            }
        }

        public static interface Interface
        extends RpcInterface {
            public void send(RPC var1, MailMessage var2, ApiBasePb.VoidProto var3, RpcCallback var4);

            public void sendToAdmins(RPC var1, MailMessage var2, ApiBasePb.VoidProto var3, RpcCallback var4);
        }

        public static class BlockingStub
        extends BaseStub
        implements BlockingInterface {
            BlockingStub(RpcStubParameters params) {
                super(params);
            }

            public ApiBasePb.VoidProto send(RPC rpc, MailMessage req) throws RpcException {
                ApiBasePb.VoidProto reply = new ApiBasePb.VoidProto();
                this.startBlockingRpc(rpc, this.Send_method_, "Send", req, reply, this.Send_parameters_);
                return reply;
            }

            public ApiBasePb.VoidProto sendToAdmins(RPC rpc, MailMessage req) throws RpcException {
                ApiBasePb.VoidProto reply = new ApiBasePb.VoidProto();
                this.startBlockingRpc(rpc, this.SendToAdmins_method_, "SendToAdmins", req, reply, this.SendToAdmins_parameters_);
                return reply;
            }
        }

        public static interface BlockingInterface
        extends RpcInterface {
            public ApiBasePb.VoidProto send(RPC var1, MailMessage var2) throws RpcException;

            public ApiBasePb.VoidProto sendToAdmins(RPC var1, MailMessage var2) throws RpcException;
        }

        private static class BaseStub
        extends RpcStub {
            protected final String Send_method_;
            protected final RPC Send_parameters_ = this.newRpcPrototype(Method.Send);
            protected final String SendToAdmins_method_;
            protected final RPC SendToAdmins_parameters_ = this.newRpcPrototype(Method.SendToAdmins);

            protected BaseStub(RpcStubParameters params) {
                super("MailService", params, Method.class);
                this.Send_method_ = this.makeFullMethodName("Send");
                this.SendToAdmins_method_ = this.makeFullMethodName("SendToAdmins");
            }
        }

        private static class SimpleStub
        extends RpcStub {
            public SimpleStub(RpcStubParameters params) {
                super("MailService", params, Method.class);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Method {
            Send,
            SendToAdmins;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MailMessage
    extends ProtocolMessage<MailMessage> {
        private static final long serialVersionUID = 1L;
        private byte[] sender_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] replyto_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private List<byte[]> to_ = null;
        private List<byte[]> cc_ = null;
        private List<byte[]> bcc_ = null;
        private byte[] subject_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] textbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] htmlbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private List<MailAttachment> attachment_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MailMessage IMMUTABLE_DEFAULT_INSTANCE = new MailMessage(){
            private static final long serialVersionUID = 1L;

            public MailMessage clearSender() {
                return this;
            }

            public MailMessage setSenderAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setSender(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setSender(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage clearReplyTo() {
                return this;
            }

            public MailMessage setReplyToAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setReplyTo(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setReplyTo(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage clearTo() {
                return this;
            }

            public MailMessage setToAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setTo(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage addToAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage addTo(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setTo(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage addTo(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage clearCc() {
                return this;
            }

            public MailMessage setCcAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setCc(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage addCcAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage addCc(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setCc(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage addCc(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage clearBcc() {
                return this;
            }

            public MailMessage setBccAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setBcc(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage addBccAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage addBcc(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setBcc(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage addBcc(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage clearSubject() {
                return this;
            }

            public MailMessage setSubjectAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setSubject(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setSubject(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage clearTextBody() {
                return this;
            }

            public MailMessage setTextBodyAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setTextBody(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setTextBody(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage clearHtmlBody() {
                return this;
            }

            public MailMessage setHtmlBodyAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setHtmlBody(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage setHtmlBody(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailMessage clearAttachment() {
                return this;
            }

            public MailAttachment getMutableAttachment(int i) {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            public MailAttachment addAttachment() {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            public MailAttachment addAttachment(MailAttachment v) {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            public MailAttachment insertAttachment(int i, MailAttachment v) {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            public MailAttachment removeAttachment(int i) {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            public MailMessage mergeFrom(MailMessage that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MailMessage freeze() {
                return this;
            }

            public MailMessage unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kSender = 1;
        public static final int kReplyTo = 2;
        public static final int kTo = 3;
        public static final int kCc = 4;
        public static final int kBcc = 5;
        public static final int kSubject = 6;
        public static final int kTextBody = 7;
        public static final int kHtmlBody = 8;
        public static final int kAttachment = 9;
        public static final String[] text = new String[10];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getSenderAsBytes() {
            return this.sender_;
        }

        public final boolean hasSender() {
            return (this.optional_0_ & 1) != 0;
        }

        public MailMessage clearSender() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.sender_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setSenderAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.sender_ = x;
            return this;
        }

        public final String getSender() {
            return ProtocolSupport.toStringUtf8(this.sender_);
        }

        public MailMessage setSender(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.sender_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getSender(Charset cs) {
            return ProtocolSupport.toString(this.sender_, cs);
        }

        public MailMessage setSender(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.sender_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getReplyToAsBytes() {
            return this.replyto_;
        }

        public final boolean hasReplyTo() {
            return (this.optional_0_ & 2) != 0;
        }

        public MailMessage clearReplyTo() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.replyto_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setReplyToAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.replyto_ = x;
            return this;
        }

        public final String getReplyTo() {
            return ProtocolSupport.toStringUtf8(this.replyto_);
        }

        public MailMessage setReplyTo(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.replyto_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getReplyTo(Charset cs) {
            return ProtocolSupport.toString(this.replyto_, cs);
        }

        public MailMessage setReplyTo(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.replyto_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final int toSize() {
            return this.to_ != null ? this.to_.size() : 0;
        }

        public final byte[] getToAsBytes(int i) {
            assert (i >= 0 && i < (this.to_ != null ? this.to_.size() : 0));
            return this.to_.get(i);
        }

        public MailMessage clearTo() {
            if (this.to_ != null) {
                this.to_.clear();
            }
            return this;
        }

        public final String getTo(int i) {
            return ProtocolSupport.toStringUtf8(this.to_.get(i));
        }

        public MailMessage setToAsBytes(int i, byte[] v) {
            this.to_.set(i, v);
            return this;
        }

        public MailMessage setTo(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.to_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public MailMessage addToAsBytes(byte[] v) {
            if (this.to_ == null) {
                this.to_ = new ArrayList<byte[]>(4);
            }
            this.to_.add(v);
            return this;
        }

        public MailMessage addTo(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.to_ == null) {
                this.to_ = new ArrayList<byte[]>(4);
            }
            this.to_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> toIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.to_);
        }

        public final List<String> tos() {
            return ProtocolSupport.byteArrayToUnicodeList(this.to_);
        }

        public final Iterator<byte[]> toAsBytesIterator() {
            return this.to_ == null ? ProtocolSupport.emptyIterator() : this.to_.iterator();
        }

        public final List<byte[]> tosAsBytes() {
            return ProtocolSupport.unmodifiableList(this.to_);
        }

        public final List<byte[]> mutableTosAsBytes() {
            if (this.to_ == null) {
                this.to_ = new ArrayList<byte[]>(4);
            }
            return this.to_;
        }

        public final String getTo(int i, Charset cs) {
            return ProtocolSupport.toString(this.to_.get(i), cs);
        }

        public MailMessage setTo(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.to_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public MailMessage addTo(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.to_ == null) {
                this.to_ = new ArrayList<byte[]>(4);
            }
            this.to_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> toIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.to_, cs);
        }

        public final List<String> tos(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.to_, cs);
        }

        public final int ccSize() {
            return this.cc_ != null ? this.cc_.size() : 0;
        }

        public final byte[] getCcAsBytes(int i) {
            assert (i >= 0 && i < (this.cc_ != null ? this.cc_.size() : 0));
            return this.cc_.get(i);
        }

        public MailMessage clearCc() {
            if (this.cc_ != null) {
                this.cc_.clear();
            }
            return this;
        }

        public final String getCc(int i) {
            return ProtocolSupport.toStringUtf8(this.cc_.get(i));
        }

        public MailMessage setCcAsBytes(int i, byte[] v) {
            this.cc_.set(i, v);
            return this;
        }

        public MailMessage setCc(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.cc_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public MailMessage addCcAsBytes(byte[] v) {
            if (this.cc_ == null) {
                this.cc_ = new ArrayList<byte[]>(4);
            }
            this.cc_.add(v);
            return this;
        }

        public MailMessage addCc(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.cc_ == null) {
                this.cc_ = new ArrayList<byte[]>(4);
            }
            this.cc_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> ccIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.cc_);
        }

        public final List<String> ccs() {
            return ProtocolSupport.byteArrayToUnicodeList(this.cc_);
        }

        public final Iterator<byte[]> ccAsBytesIterator() {
            return this.cc_ == null ? ProtocolSupport.emptyIterator() : this.cc_.iterator();
        }

        public final List<byte[]> ccsAsBytes() {
            return ProtocolSupport.unmodifiableList(this.cc_);
        }

        public final List<byte[]> mutableCcsAsBytes() {
            if (this.cc_ == null) {
                this.cc_ = new ArrayList<byte[]>(4);
            }
            return this.cc_;
        }

        public final String getCc(int i, Charset cs) {
            return ProtocolSupport.toString(this.cc_.get(i), cs);
        }

        public MailMessage setCc(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.cc_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public MailMessage addCc(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.cc_ == null) {
                this.cc_ = new ArrayList<byte[]>(4);
            }
            this.cc_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> ccIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.cc_, cs);
        }

        public final List<String> ccs(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.cc_, cs);
        }

        public final int bccSize() {
            return this.bcc_ != null ? this.bcc_.size() : 0;
        }

        public final byte[] getBccAsBytes(int i) {
            assert (i >= 0 && i < (this.bcc_ != null ? this.bcc_.size() : 0));
            return this.bcc_.get(i);
        }

        public MailMessage clearBcc() {
            if (this.bcc_ != null) {
                this.bcc_.clear();
            }
            return this;
        }

        public final String getBcc(int i) {
            return ProtocolSupport.toStringUtf8(this.bcc_.get(i));
        }

        public MailMessage setBccAsBytes(int i, byte[] v) {
            this.bcc_.set(i, v);
            return this;
        }

        public MailMessage setBcc(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.bcc_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public MailMessage addBccAsBytes(byte[] v) {
            if (this.bcc_ == null) {
                this.bcc_ = new ArrayList<byte[]>(4);
            }
            this.bcc_.add(v);
            return this;
        }

        public MailMessage addBcc(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.bcc_ == null) {
                this.bcc_ = new ArrayList<byte[]>(4);
            }
            this.bcc_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> bccIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.bcc_);
        }

        public final List<String> bccs() {
            return ProtocolSupport.byteArrayToUnicodeList(this.bcc_);
        }

        public final Iterator<byte[]> bccAsBytesIterator() {
            return this.bcc_ == null ? ProtocolSupport.emptyIterator() : this.bcc_.iterator();
        }

        public final List<byte[]> bccsAsBytes() {
            return ProtocolSupport.unmodifiableList(this.bcc_);
        }

        public final List<byte[]> mutableBccsAsBytes() {
            if (this.bcc_ == null) {
                this.bcc_ = new ArrayList<byte[]>(4);
            }
            return this.bcc_;
        }

        public final String getBcc(int i, Charset cs) {
            return ProtocolSupport.toString(this.bcc_.get(i), cs);
        }

        public MailMessage setBcc(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.bcc_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public MailMessage addBcc(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.bcc_ == null) {
                this.bcc_ = new ArrayList<byte[]>(4);
            }
            this.bcc_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> bccIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.bcc_, cs);
        }

        public final List<String> bccs(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.bcc_, cs);
        }

        public final byte[] getSubjectAsBytes() {
            return this.subject_;
        }

        public final boolean hasSubject() {
            return (this.optional_0_ & 4) != 0;
        }

        public MailMessage clearSubject() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.subject_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setSubjectAsBytes(byte[] x) {
            this.optional_0_ |= 4;
            this.subject_ = x;
            return this;
        }

        public final String getSubject() {
            return ProtocolSupport.toStringUtf8(this.subject_);
        }

        public MailMessage setSubject(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.subject_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getSubject(Charset cs) {
            return ProtocolSupport.toString(this.subject_, cs);
        }

        public MailMessage setSubject(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.subject_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getTextBodyAsBytes() {
            return this.textbody_;
        }

        public final boolean hasTextBody() {
            return (this.optional_0_ & 8) != 0;
        }

        public MailMessage clearTextBody() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.textbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setTextBodyAsBytes(byte[] x) {
            this.optional_0_ |= 8;
            this.textbody_ = x;
            return this;
        }

        public final String getTextBody() {
            return ProtocolSupport.toStringUtf8(this.textbody_);
        }

        public MailMessage setTextBody(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.textbody_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getTextBody(Charset cs) {
            return ProtocolSupport.toString(this.textbody_, cs);
        }

        public MailMessage setTextBody(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.textbody_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getHtmlBodyAsBytes() {
            return this.htmlbody_;
        }

        public final boolean hasHtmlBody() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public MailMessage clearHtmlBody() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.htmlbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setHtmlBodyAsBytes(byte[] x) {
            this.optional_0_ |= 0x10;
            this.htmlbody_ = x;
            return this;
        }

        public final String getHtmlBody() {
            return ProtocolSupport.toStringUtf8(this.htmlbody_);
        }

        public MailMessage setHtmlBody(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.htmlbody_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getHtmlBody(Charset cs) {
            return ProtocolSupport.toString(this.htmlbody_, cs);
        }

        public MailMessage setHtmlBody(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.htmlbody_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final int attachmentSize() {
            return this.attachment_ != null ? this.attachment_.size() : 0;
        }

        public final MailAttachment getAttachment(int i) {
            assert (i >= 0 && i < (this.attachment_ != null ? this.attachment_.size() : 0));
            return this.attachment_.get(i);
        }

        public MailMessage clearAttachment() {
            if (this.attachment_ != null) {
                this.attachment_.clear();
            }
            return this;
        }

        public MailAttachment getMutableAttachment(int i) {
            assert (i >= 0 && this.attachment_ != null && i < this.attachment_.size());
            return this.attachment_.get(i);
        }

        public MailAttachment addAttachment() {
            MailAttachment v = new MailAttachment();
            if (this.attachment_ == null) {
                this.attachment_ = new ArrayList<MailAttachment>(4);
            }
            this.attachment_.add(v);
            return v;
        }

        public MailAttachment addAttachment(MailAttachment v) {
            if (this.attachment_ == null) {
                this.attachment_ = new ArrayList<MailAttachment>(4);
            }
            this.attachment_.add(v);
            return v;
        }

        public MailAttachment insertAttachment(int i, MailAttachment v) {
            if (this.attachment_ == null) {
                this.attachment_ = new ArrayList<MailAttachment>(4);
            }
            this.attachment_.add(i, v);
            return v;
        }

        public MailAttachment removeAttachment(int i) {
            return this.attachment_.remove(i);
        }

        public final Iterator<MailAttachment> attachmentIterator() {
            if (this.attachment_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.attachment_.iterator();
        }

        public final List<MailAttachment> attachments() {
            return ProtocolSupport.unmodifiableList(this.attachment_);
        }

        public final List<MailAttachment> mutableAttachments() {
            if (this.attachment_ == null) {
                this.attachment_ = new ArrayList<MailAttachment>(4);
            }
            return this.attachment_;
        }

        @Override
        public MailMessage mergeFrom(MailMessage that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.sender_ = that.sender_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.replyto_ = that.replyto_;
            }
            if (that.to_ != null && that.to_.size() > 0) {
                if (this.to_ == null) {
                    this.to_ = new ArrayList<byte[]>(that.to_);
                } else {
                    this.to_.addAll(that.to_);
                }
            }
            if (that.cc_ != null && that.cc_.size() > 0) {
                if (this.cc_ == null) {
                    this.cc_ = new ArrayList<byte[]>(that.cc_);
                } else {
                    this.cc_.addAll(that.cc_);
                }
            }
            if (that.bcc_ != null && that.bcc_.size() > 0) {
                if (this.bcc_ == null) {
                    this.bcc_ = new ArrayList<byte[]>(that.bcc_);
                } else {
                    this.bcc_.addAll(that.bcc_);
                }
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.subject_ = that.subject_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.textbody_ = that.textbody_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.htmlbody_ = that.htmlbody_;
            }
            if (that.attachment_ != null) {
                for (MailAttachment v : that.attachment_) {
                    this.addAttachment().mergeFrom(v);
                }
            }
            if ((that_t0 & 0x20) != 0) {
                this_t0 |= 0x20;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MailMessage that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MailMessage that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MailMessage that, boolean ignoreUninterpreted) {
            int i;
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFDF) != (that_t0 & 0xFFFFFFDF)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.sender_, that.sender_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.replyto_, that.replyto_)) {
                return false;
            }
            int n = this.to_ != null ? this.to_.size() : 0;
            if (n != (that.to_ != null ? that.to_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (Arrays.equals(this.to_.get(i), that.to_.get(i))) continue;
                return false;
            }
            n = this.cc_ != null ? this.cc_.size() : 0;
            if (n != (that.cc_ != null ? that.cc_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (Arrays.equals(this.cc_.get(i), that.cc_.get(i))) continue;
                return false;
            }
            n = this.bcc_ != null ? this.bcc_.size() : 0;
            if (n != (that.bcc_ != null ? that.bcc_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (Arrays.equals(this.bcc_.get(i), that.bcc_.get(i))) continue;
                return false;
            }
            if ((this_t0 & 4) != 0 && !Arrays.equals(this.subject_, that.subject_)) {
                return false;
            }
            if ((this_t0 & 8) != 0 && !Arrays.equals(this.textbody_, that.textbody_)) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && !Arrays.equals(this.htmlbody_, that.htmlbody_)) {
                return false;
            }
            n = this.attachment_ != null ? this.attachment_.size() : 0;
            if (n != (that.attachment_ != null ? that.attachment_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (this.attachment_.get(i).equals(that.attachment_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 0x20) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MailMessage && this.equals((MailMessage)that);
        }

        @Override
        public int hashCode() {
            int i;
            int n;
            int hash = -1153084626;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.sender_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.replyto_) : -113);
            hash *= 31;
            int n2 = n = this.to_ != null ? this.to_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.to_.get(i));
            }
            hash *= 31;
            int n3 = n = this.cc_ != null ? this.cc_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.cc_.get(i));
            }
            hash *= 31;
            int n4 = n = this.bcc_ != null ? this.bcc_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.bcc_.get(i));
            }
            hash = hash * 31 + ((this_t0 & 4) != 0 ? Arrays.hashCode(this.subject_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? Arrays.hashCode(this.textbody_) : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? Arrays.hashCode(this.htmlbody_) : -113);
            hash *= 31;
            int n5 = n = this.attachment_ != null ? this.attachment_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + this.attachment_.get(i).hashCode();
            }
            if ((this_t0 & 0x20) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 5) != 5) {
                if ((this_t0 & 1) == 0) {
                    return "missing field: Sender";
                }
                return "missing field: Subject";
            }
            if (this.attachment_ != null) {
                for (MailAttachment v : this.attachment_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int i;
            int n = 2 + Protocol.stringSize(this.sender_.length) + Protocol.stringSize(this.subject_.length);
            int m = this.to_ != null ? this.to_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.to_.get(i).length);
            }
            m = this.cc_ != null ? this.cc_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.cc_.get(i).length);
            }
            m = this.bcc_ != null ? this.bcc_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.bcc_.get(i).length);
            }
            m = this.attachment_ != null ? this.attachment_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.attachment_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x1A) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 1 + Protocol.stringSize(this.replyto_.length);
                }
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.stringSize(this.textbody_.length);
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 1 + Protocol.stringSize(this.htmlbody_.length);
                }
            }
            return (this_t0 & 0x20) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int i;
            int n = 12 + this.sender_.length + this.subject_.length;
            int m = this.to_ != null ? this.to_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.to_.get(i).length;
            }
            m = this.cc_ != null ? this.cc_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.cc_.get(i).length;
            }
            m = this.bcc_ != null ? this.bcc_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.bcc_.get(i).length;
            }
            m = this.attachment_ != null ? this.attachment_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.attachment_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x1A) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 6 + this.replyto_.length;
                }
                if ((this_t0 & 8) != 0) {
                    n += 6 + this.textbody_.length;
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 6 + this.htmlbody_.length;
                }
            }
            return (this_t0 & 0x20) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 0x20;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.sender_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.replyto_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.to_ != null) {
                this.to_.clear();
            }
            if (this.cc_ != null) {
                this.cc_.clear();
            }
            if (this.bcc_ != null) {
                this.bcc_.clear();
            }
            this.subject_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.textbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.htmlbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.attachment_ != null) {
                this.attachment_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public MailMessage newInstance() {
            return new MailMessage();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            Object v;
            int i;
            int m;
            sink.putByte((byte)10);
            sink.putPrefixedData(this.sender_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)18);
                sink.putPrefixedData(this.replyto_);
            }
            int n = m = this.to_ != null ? this.to_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.to_.get(i);
                sink.putByte((byte)26);
                sink.putPrefixedData((byte[])v);
            }
            int n2 = m = this.cc_ != null ? this.cc_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.cc_.get(i);
                sink.putByte((byte)34);
                sink.putPrefixedData((byte[])v);
            }
            int n3 = m = this.bcc_ != null ? this.bcc_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.bcc_.get(i);
                sink.putByte((byte)42);
                sink.putPrefixedData((byte[])v);
            }
            sink.putByte((byte)50);
            sink.putPrefixedData(this.subject_);
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)58);
                sink.putPrefixedData(this.textbody_);
            }
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)66);
                sink.putPrefixedData(this.htmlbody_);
            }
            int n4 = m = this.attachment_ != null ? this.attachment_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.attachment_.get(i);
                sink.putByte((byte)74);
                sink.putForeign((ProtocolMessage)v);
            }
            if ((this_t0 & 0x20) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block12: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block12;
                    }
                    case 10: {
                        this.sender_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block12;
                    }
                    case 18: {
                        this.replyto_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block12;
                    }
                    case 26: {
                        this.addToAsBytes(source.getPrefixedData());
                        continue block12;
                    }
                    case 34: {
                        this.addCcAsBytes(source.getPrefixedData());
                        continue block12;
                    }
                    case 42: {
                        this.addBccAsBytes(source.getPrefixedData());
                        continue block12;
                    }
                    case 50: {
                        this.subject_ = source.getPrefixedData();
                        this_t0 |= 4;
                        continue block12;
                    }
                    case 58: {
                        this.textbody_ = source.getPrefixedData();
                        this_t0 |= 8;
                        continue block12;
                    }
                    case 66: {
                        this.htmlbody_ = source.getPrefixedData();
                        this_t0 |= 0x10;
                        continue block12;
                    }
                    case 74: {
                        source.push(source.getVarInt());
                        if (!this.addAttachment().merge(source)) {
                            result = false;
                            break block12;
                        }
                        source.pop();
                        continue block12;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 0x20;
                        continue block12;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MailMessage freeze() {
            this.sender_ = ProtocolSupport.freezeString(this.sender_);
            this.replyto_ = ProtocolSupport.freezeString(this.replyto_);
            this.to_ = ProtocolSupport.freezeStrings(this.to_);
            this.cc_ = ProtocolSupport.freezeStrings(this.cc_);
            this.bcc_ = ProtocolSupport.freezeStrings(this.bcc_);
            this.subject_ = ProtocolSupport.freezeString(this.subject_);
            this.textbody_ = ProtocolSupport.freezeString(this.textbody_);
            this.htmlbody_ = ProtocolSupport.freezeString(this.htmlbody_);
            this.attachment_ = ProtocolSupport.freezeMessages(this.attachment_);
            return this;
        }

        @Override
        public MailMessage unfreeze() {
            this.to_ = ProtocolSupport.unfreezeStrings(this.to_);
            this.cc_ = ProtocolSupport.unfreezeStrings(this.cc_);
            this.bcc_ = ProtocolSupport.unfreezeStrings(this.bcc_);
            this.attachment_ = ProtocolSupport.unfreezeMessages(this.attachment_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenStrings(this.to_) || ProtocolSupport.isFrozenStrings(this.cc_) || ProtocolSupport.isFrozenStrings(this.bcc_) || ProtocolSupport.isFrozenMessages(this.attachment_);
        }

        static {
            MailMessage.text[0] = "ErrorCode";
            MailMessage.text[1] = "Sender";
            MailMessage.text[2] = "ReplyTo";
            MailMessage.text[3] = "To";
            MailMessage.text[4] = "Cc";
            MailMessage.text[5] = "Bcc";
            MailMessage.text[6] = "Subject";
            MailMessage.text[7] = "TextBody";
            MailMessage.text[8] = "HtmlBody";
            MailMessage.text[9] = "Attachment";
            types = new int[10];
            Arrays.fill(types, 6);
            MailMessage.types[0] = 0;
            MailMessage.types[1] = 2;
            MailMessage.types[2] = 2;
            MailMessage.types[3] = 2;
            MailMessage.types[4] = 2;
            MailMessage.types[5] = 2;
            MailMessage.types[6] = 2;
            MailMessage.types[7] = 2;
            MailMessage.types[8] = 2;
            MailMessage.types[9] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MailMessage.class, "Z!apphosting/api/mail_service.proto\n\u0016apphosting.MailMessage\u0013\u001a\u0006Sender \u0001(\u00020\t8\u0002\u0014\u0013\u001a\u0007ReplyTo \u0002(\u00020\t8\u0001\u0014\u0013\u001a\u0002To \u0003(\u00020\t8\u0003\u0014\u0013\u001a\u0002Cc \u0004(\u00020\t8\u0003\u0014\u0013\u001a\u0003Bcc \u0005(\u00020\t8\u0003\u0014\u0013\u001a\u0007Subject \u0006(\u00020\t8\u0002\u0014\u0013\u001a\bTextBody \u0007(\u00020\t8\u0001\u0014\u0013\u001a\bHtmlBody \b(\u00020\t8\u0001\u0014\u0013\u001a\nAttachment \t(\u00020\u000b8\u0003J\u0019apphosting.MailAttachment\u0014", new ProtocolType.FieldType("Sender", "sender", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("ReplyTo", "replyto", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("To", "to", 3, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("Cc", "cc", 4, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("Bcc", "bcc", 5, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("Subject", "subject", 6, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("TextBody", "textbody", 7, 3, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("HtmlBody", "htmlbody", 8, 4, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("Attachment", "attachment", 9, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, MailAttachment.class));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MailAttachment
    extends ProtocolMessage<MailAttachment> {
        private static final long serialVersionUID = 1L;
        private byte[] filename_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] data_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MailAttachment IMMUTABLE_DEFAULT_INSTANCE = new MailAttachment(){
            private static final long serialVersionUID = 1L;

            public MailAttachment clearFileName() {
                return this;
            }

            public MailAttachment setFileNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailAttachment setFileName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailAttachment setFileName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailAttachment clearData() {
                return this;
            }

            public MailAttachment setDataAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailAttachment setData(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailAttachment setData(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public MailAttachment mergeFrom(MailAttachment that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MailAttachment freeze() {
                return this;
            }

            public MailAttachment unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kFileName = 1;
        public static final int kData = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getFileNameAsBytes() {
            return this.filename_;
        }

        public final boolean hasFileName() {
            return (this.optional_0_ & 1) != 0;
        }

        public MailAttachment clearFileName() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.filename_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailAttachment setFileNameAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.filename_ = x;
            return this;
        }

        public final String getFileName() {
            return ProtocolSupport.toStringUtf8(this.filename_);
        }

        public MailAttachment setFileName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.filename_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getFileName(Charset cs) {
            return ProtocolSupport.toString(this.filename_, cs);
        }

        public MailAttachment setFileName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.filename_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getDataAsBytes() {
            return this.data_;
        }

        public final boolean hasData() {
            return (this.optional_0_ & 2) != 0;
        }

        public MailAttachment clearData() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.data_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailAttachment setDataAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.data_ = x;
            return this;
        }

        public final String getData() {
            return ProtocolSupport.toStringUtf8(this.data_);
        }

        public MailAttachment setData(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.data_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getData(Charset cs) {
            return ProtocolSupport.toString(this.data_, cs);
        }

        public MailAttachment setData(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.data_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public MailAttachment mergeFrom(MailAttachment that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.filename_ = that.filename_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.data_ = that.data_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MailAttachment that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MailAttachment that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MailAttachment that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFB) != (that_t0 & 0xFFFFFFFB)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.filename_, that.filename_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.data_, that.data_)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 4) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MailAttachment && this.equals((MailAttachment)that);
        }

        @Override
        public int hashCode() {
            int hash = -1936143812;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.filename_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.data_) : -113);
            if ((this_t0 & 4) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 3) {
                if ((this_t0 & 1) == 0) {
                    return "missing field: FileName";
                }
                return "missing field: Data";
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 2 + Protocol.stringSize(this.filename_.length) + Protocol.stringSize(this.data_.length);
            int this_t0 = this.optional_0_;
            return (this_t0 & 4) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 12 + this.filename_.length + this.data_.length;
            int this_t0 = this.optional_0_;
            return (this_t0 & 4) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 4;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.filename_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.data_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public MailAttachment newInstance() {
            return new MailAttachment();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.filename_);
            sink.putByte((byte)18);
            sink.putPrefixedData(this.data_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 4) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        this.filename_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 18: {
                        this.data_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 4;
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MailAttachment freeze() {
            this.filename_ = ProtocolSupport.freezeString(this.filename_);
            this.data_ = ProtocolSupport.freezeString(this.data_);
            return this;
        }

        static {
            MailAttachment.text[0] = "ErrorCode";
            MailAttachment.text[1] = "FileName";
            MailAttachment.text[2] = "Data";
            types = new int[3];
            Arrays.fill(types, 6);
            MailAttachment.types[0] = 0;
            MailAttachment.types[1] = 2;
            MailAttachment.types[2] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MailAttachment.class, "Z!apphosting/api/mail_service.proto\n\u0019apphosting.MailAttachment\u0013\u001a\bFileName \u0001(\u00020\t8\u0002\u0014\u0013\u001a\u0004Data \u0002(\u00020\t8\u0002\u0014", new ProtocolType.FieldType("FileName", "filename", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("Data", "data", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MailServiceError
    extends ProtocolMessage<MailServiceError> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MailServiceError IMMUTABLE_DEFAULT_INSTANCE = new MailServiceError(){
            private static final long serialVersionUID = 1L;

            public MailServiceError mergeFrom(MailServiceError that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public MailServiceError freeze() {
                return this;
            }

            public MailServiceError unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public MailServiceError mergeFrom(MailServiceError that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MailServiceError that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MailServiceError that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MailServiceError that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MailServiceError && this.equals((MailServiceError)that);
        }

        @Override
        public int hashCode() {
            int hash = -448357120;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public MailServiceError newInstance() {
            return new MailServiceError();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block3;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            MailServiceError.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            MailServiceError.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(MailServiceError.class, "Z!apphosting/api/mail_service.proto\n\u001bapphosting.MailServiceErrorsz\tErrorCode\u008b\u0001\u0092\u0001\u0002OK\u0098\u0001\u0000\u008c\u0001\u008b\u0001\u0092\u0001\u000eINTERNAL_ERROR\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u000bBAD_REQUEST\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0013UNAUTHORIZED_SENDER\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\u0017INVALID_ATTACHMENT_TYPE\u0098\u0001\u0004\u008c\u0001t", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ErrorCode implements ProtocolMessageEnum
        {
            OK(0),
            INTERNAL_ERROR(1),
            BAD_REQUEST(2),
            UNAUTHORIZED_SENDER(3),
            INVALID_ATTACHMENT_TYPE(4);

            public static final ErrorCode ErrorCode_MIN;
            public static final ErrorCode ErrorCode_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static ErrorCode valueOf(int value) {
                switch (value) {
                    case 0: {
                        return OK;
                    }
                    case 1: {
                        return INTERNAL_ERROR;
                    }
                    case 2: {
                        return BAD_REQUEST;
                    }
                    case 3: {
                        return UNAUTHORIZED_SENDER;
                    }
                    case 4: {
                        return INVALID_ATTACHMENT_TYPE;
                    }
                }
                return null;
            }

            private ErrorCode(int v) {
                this.value = v;
            }

            static {
                ErrorCode_MIN = OK;
                ErrorCode_MAX = INVALID_ATTACHMENT_TYPE;
            }
        }
    }
}

