/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.DatastorePb;
import java.util.logging.Logger;

class TransactionImpl
implements Transaction {
    private static final Logger logger = Logger.getLogger(TransactionImpl.class.getName());
    private final long handle;
    private final TransactionStack txnStack;
    TransactionState state = TransactionState.BEGUN;

    TransactionImpl(long handle, TransactionStack txnStack) {
        this.handle = handle;
        this.txnStack = txnStack;
    }

    void makeSyncCall(String methodName, ProtocolMessage request, ProtocolMessage response) {
        DatastoreApiHelper.makeSyncCall(methodName, request, response);
    }

    private void makeSyncCall(String methodName, ProtocolMessage response) {
        if (this.state != TransactionState.BEGUN) {
            throw new IllegalStateException("Transaction is in state " + (Object)((Object)this.state) + ".  There is no legal " + "transition out of this state.");
        }
        DatastorePb.Transaction txn = new DatastorePb.Transaction();
        txn.setHandle(this.handle);
        try {
            this.makeSyncCall(methodName, txn, response);
        }
        catch (RuntimeException rte) {
            this.state = TransactionState.ERROR;
            throw rte;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        try {
            this.makeSyncCall("Commit", new DatastorePb.CommitResponse());
            this.state = TransactionState.COMMITTED;
        }
        finally {
            this.txnStack.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            this.makeSyncCall("Rollback", new ApiBasePb.VoidProto());
            this.state = TransactionState.ROLLED_BACK;
        }
        finally {
            this.txnStack.remove(this);
        }
    }

    public String getId() {
        return Long.toString(this.handle);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionImpl that = (TransactionImpl)o;
        return this.handle == that.handle;
    }

    public int hashCode() {
        return (int)(this.handle ^ this.handle >>> 32);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TransactionState {
        BEGUN,
        COMMITTED,
        ROLLED_BACK,
        ERROR;

    }
}

