/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

public final class FetchOptions {
    public static final int DEFAULT_CHUNK_SIZE = 10;
    static final int NO_LIMIT = -1;
    static final int NO_OFFSET = -1;
    private int limit = -1;
    private int offset = -1;
    private int chunkSize = 10;

    private FetchOptions() {
    }

    public FetchOptions limit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("Limit must be greater than 0.");
        }
        this.limit = limit;
        return this;
    }

    public FetchOptions offset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be 0 or greater.");
        }
        this.offset = offset;
        return this;
    }

    public FetchOptions chunkSize(int chunkSize) {
        if (chunkSize < 1) {
            throw new IllegalArgumentException("Chunk size must be greater than 0.");
        }
        this.chunkSize = chunkSize;
        return this;
    }

    int getLimit() {
        return this.limit;
    }

    int getOffset() {
        return this.offset;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    boolean hasLimit() {
        return this.limit != -1;
    }

    boolean hasOffset() {
        return this.offset != -1;
    }

    public static final class Builder {
        public static FetchOptions withLimit(int limit) {
            return Builder.withDefault().limit(limit);
        }

        public static FetchOptions withOffset(int offset) {
            return Builder.withDefault().offset(offset);
        }

        public static FetchOptions withChunkSize(int chunkSize) {
            return Builder.withDefault().chunkSize(chunkSize);
        }

        static FetchOptions withDefault() {
            return new FetchOptions();
        }

        private Builder() {
        }
    }
}

