/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreNeedIndexException;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import java.util.ConcurrentModificationException;

final class DatastoreApiHelper {
    static final String PACKAGE = "datastore_v3";

    private DatastoreApiHelper() {
    }

    private static RuntimeException translateError(ApiProxy.ApplicationException exception) {
        DatastorePb.Error.ErrorCode errorCode = DatastorePb.Error.ErrorCode.valueOf(exception.getApplicationError());
        switch (errorCode) {
            case BAD_REQUEST: {
                return new IllegalArgumentException(exception.getErrorDetail());
            }
            case CONCURRENT_TRANSACTION: {
                return new ConcurrentModificationException(exception.getErrorDetail());
            }
            case NEED_INDEX: {
                return new DatastoreNeedIndexException(exception.getErrorDetail());
            }
            case TIMEOUT: {
                return new DatastoreTimeoutException(exception.getErrorDetail());
            }
        }
        return new DatastoreFailureException(exception.getErrorDetail());
    }

    static void makeSyncCall(String method, ProtocolMessage request, ProtocolMessage response) {
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, method, request.toByteArray());
            if (responseBytes != null) {
                response.mergeFrom(responseBytes);
            }
        }
        catch (ApiProxy.ApplicationException exception) {
            throw DatastoreApiHelper.translateError(exception);
        }
    }

    static String getCurrentAppId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new NullPointerException("No API environment is registered for this thread.");
        }
        return environment.getAppId();
    }
}

