/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Link;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.users.User;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataTypeUtils {
    public static final int MAX_STRING_PROPERTY_LENGTH = 500;
    public static final int MAX_SHORT_BLOB_PROPERTY_LENGTH = 500;
    public static final int MAX_LINK_PROPERTY_LENGTH = 2038;
    private static final Set<Class<?>> supportedTypes = new HashSet();

    public static void checkSupportedValue(Object value) {
        if (value instanceof Collection) {
            for (Object obj : (Collection)value) {
                DataTypeUtils.checkSupportedSingleValue(obj);
            }
            return;
        }
        DataTypeUtils.checkSupportedSingleValue(value);
    }

    private static void checkSupportedSingleValue(Object value) {
        int length;
        if (value == null) {
            return;
        }
        if (!DataTypeUtils.isSupportedType(value.getClass())) {
            throw new IllegalArgumentException(value.getClass().getName() + " is not a supported property type.");
        }
        if (value instanceof String) {
            int length2 = ((String)value).length();
            if (length2 > 500) {
                throw new IllegalArgumentException("String properties must be 500 characters or less.  Instead, use " + Text.class.getName() + ", which can store " + "strings of any length.");
            }
        } else if (value instanceof Link) {
            int length3 = ((Link)value).getValue().length();
            if (length3 > 2038) {
                throw new IllegalArgumentException("Link properties must be 2038 characters or less.  Instead, use " + Text.class.getName() + ", which can store " + "strings of any length.");
            }
        } else if (value instanceof ShortBlob && (length = ((ShortBlob)value).getBytes().length) > 500) {
            throw new IllegalArgumentException("byte[] properties must be 500 bytes or less.  Instead, use " + Blob.class.getName() + ", which can store binary " + "data of any size.");
        }
    }

    public static boolean isSupportedType(Class<?> clazz) {
        return supportedTypes.contains(clazz);
    }

    public static Set<Class<?>> getSupportedTypes() {
        return Collections.unmodifiableSet(supportedTypes);
    }

    private DataTypeUtils() {
    }

    static {
        supportedTypes.add(Boolean.class);
        supportedTypes.add(String.class);
        supportedTypes.add(Byte.class);
        supportedTypes.add(Short.class);
        supportedTypes.add(Integer.class);
        supportedTypes.add(Long.class);
        supportedTypes.add(Float.class);
        supportedTypes.add(Double.class);
        supportedTypes.add(User.class);
        supportedTypes.add(Key.class);
        supportedTypes.add(Blob.class);
        supportedTypes.add(Text.class);
        supportedTypes.add(Date.class);
        supportedTypes.add(Link.class);
        supportedTypes.add(ShortBlob.class);
    }
}

