/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

public class WebDriverException
extends RuntimeException {
    public WebDriverException() {
    }

    public WebDriverException(String message) {
        super(message);
    }

    public WebDriverException(Throwable cause) {
        super(cause);
    }

    public WebDriverException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getMessage() {
        return this.createMessage(super.getMessage());
    }

    private String createMessage(String originalMessageString) {
        return String.format("%sSystem info: %s\nDriver info: %s", originalMessageString == null ? "" : originalMessageString + "\n", this.getSystemInformation(), this.getDriverInformation());
    }

    public String getSystemInformation() {
        return String.format("os.name: '%s', os.arch: '%s', os.version: '%s', java.version: '%s'", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.version"));
    }

    public String getDriverInformation() {
        for (StackTraceElement e : this.getStackTrace()) {
            String[] bits;
            if (!e.getClassName().startsWith("org.openqa.selenium") || (bits = e.getClassName().split("\\.")).length <= 3 || "support".equals("bits")) continue;
            return "driver.version: " + bits[3];
        }
        return "driver.version: unknown";
    }
}

