﻿using System;
using System.Collections.Specialized;
using System.IO;
using System.Linq;
using System.Net;
using System.Security.Cryptography;
using System.Text;
using System.Xml.Linq;

namespace Azyobuzi.HatenaDiaryClient.Models.Hatena
{
    public static class WsseAtomConnection
    {
        private static Random random = new Random();

        public static string CreateHeader(string userName, string password)
        {
            var nonce = new byte[8];
            random.NextBytes(nonce);
            var created = DateTime.Now.ToUniversalTime().ToString("o");
            var digest = Convert.ToBase64String(
                new SHA1Managed().ComputeHash(
                    nonce.Concat(Encoding.ASCII.GetBytes(created)).Concat(Encoding.ASCII.GetBytes(password)).ToArray()
                ));
            return string.Format(
                @"X-WSSE:UsernameToken Username=""{0}"", PasswordDigest=""{1}"", Nonce=""{2}"", Created=""{3}""",
                userName, digest, Convert.ToBase64String(nonce), created);
        }

        public static XDocument Get(string reqUri, Encoding enc, string userName, string password)
        {
            using (var wc = new WebClient())
            {
                wc.Headers.Add(CreateHeader(userName, password));
                using (var sr = new StreamReader(wc.OpenRead(reqUri), enc ?? Encoding.UTF8))
                    return XDocument.Load(sr);
            }
        }

        public static void Delete(string reqUri, string userName, string password)
        {
            var req = WebRequest.Create(reqUri);
            req.Method = "DELETE";
            req.Headers.Add(CreateHeader(userName, password));
            req.GetResponse().Close();
        }

        private static XDocument PostOrPut(string reqUri, string method, XDocument reqData, Encoding enc, string userName, string password)
        {
            var req = WebRequest.Create(reqUri);
            req.Method = method;
            req.Headers.Add(CreateHeader(userName, password));
            req.ContentType = "application/x.atom+xml";
            var bs = enc.GetBytes(reqData.ToString());
            req.ContentLength = bs.Length;
            using (var stream = req.GetRequestStream())
                stream.Write(bs, 0, bs.Length);
            using (var res = req.GetResponse())
                return XDocument.Load(res.GetResponseStream());
        }

        public static XDocument Post(string reqUri, XDocument reqData, Encoding enc, string userName, string password)
        {
            return PostOrPut(reqUri, "POST", reqData, enc, userName, password);
        }

        public static XDocument Put(string reqUri, XDocument reqData, Encoding enc, string userName, string password)
        {
            return PostOrPut(reqUri, "PUT", reqData, enc, userName, password);
        }

        public static string Put(string reqUri, NameValueCollection headers, byte[] data, Encoding enc, string userName, string password)
        {
            var req = WebRequest.Create(reqUri);
            req.Method = "PUT";
            req.Headers.Add(CreateHeader(userName, password));
            if (headers != null)
                req.Headers.Add(headers);
            if (data != null && data.Any())
            {
                using (var stream = req.GetRequestStream())
                    stream.Write(data, 0, data.Length);
            }
            using (var sr = new StreamReader(req.GetResponse().GetResponseStream(), enc ?? Encoding.UTF8))
                return sr.ReadToEnd();
        }
    }
}