/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "uri_opener.hxx"

#include <memory>
#include "bbs_detail_judge.hxx"
#include "bbs_detail_base.hxx"
#include "application_window.hxx"
#include "thread_window.hxx"
#include "board_window.hxx"


namespace dialektos {

namespace uri_opener {


bool open(const std::string& uri) {
  std::auto_ptr<bbs_detail::Base> bbs = bbs_detail::judge(uri);
  if (!bbs.get())
    return false;

  if (ApplicationWindow* window = dialektos::ApplicationWindow::find(*bbs)) {
    window->present();
    return true;
  }

  if (bbs->is_thread()) {
    dialektos::ThreadWindow::create(bbs);
    return true;
  }

  if (bbs->is_board()) {
    dialektos::BoardWindow::create(bbs);
    return true;
  }

  return false;
}


} // namespace uri_opener

} // namespace dialektos
