/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "thread_window_state.hxx"

#include <boost/archive/xml_iarchive.hpp>
#include <boost/archive/xml_oarchive.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/filesystem.hpp>
#include <fstream>
#include <iostream>
#include <string>
#include "misc.hxx"


namespace dialektos {


ThreadWindowState::ThreadWindowState() :
  width(400), height(300), displayed_res_num(0),
  menubar(true), toolbar(true), statusbar(true) {
}

void ThreadWindowState::from_xml(const boost::filesystem::path& xml) {
  if (!boost::filesystem::exists(xml) ||
      !boost::filesystem::is_regular_file(xml))
    return;

  std::ifstream ifs(xml.file_string().c_str());
  try {
    boost::archive::xml_iarchive ia(ifs);
    ia >> boost::serialization::make_nvp("ThreadWindowState", *this);
  } catch (const boost::archive::archive_exception& e) {
    std::cerr << e.what() << " " << xml << std::endl;
  }
}

void ThreadWindowState::to_xml(const boost::filesystem::path& xml) {
  // do not save if corresponding dat file does not exist.
  std::string leaf = xml.leaf();
  boost::filesystem::path dat =
    xml.parent_path().parent_path() /
    "dat" / (leaf.substr(0, leaf.size() - 3) + "dat");
  if (!boost::filesystem::exists(dat)) return;
  if (!misc::create_directories(xml.parent_path())) return;
  std::ofstream ofs(xml.file_string().c_str());
  try {
    boost::archive::xml_oarchive oa(ofs);
    oa << boost::serialization::make_nvp("ThreadWindowState", *this);
  } catch (const boost::archive::archive_exception& e) {
    std::cerr << e.what() << " " << xml << std::endl;
  }
}


} // namespace dialektos
