/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef THREAD_WINDOW_HXX
#define THREAD_WINDOW_HXX

#include <boost/scoped_ptr.hpp>
#include <memory>
#include "application_framework.hxx"
#include "text_view.hxx"
#include "scrolled_container.hxx"
#include "http_get.hxx"
#include "thread_idx.hxx"


namespace dialektos {


namespace bbs_detail {
  class Base;
}


class ThreadWindow: public ApplicationFrameWork {
  typedef ApplicationFrameWork SuperClass;
public:
  static void create(std::auto_ptr<bbs_detail::Base> bbs);
  bool load();
  virtual ~ThreadWindow(){}
  virtual void save_state() const;
  void on_informed_from_board(int res_num);
  const bbs_detail::Base& get_bbs_detail() const { return *bbs_; }
protected:
  ThreadWindow(std::auto_ptr<bbs_detail::Base> bbs);

  virtual void on_action_view_refresh();
  virtual void on_action_view_stop();
  virtual void on_action_edit_copy();
  void on_action_file_delete();
  void on_action_file_board();
  void on_action_file_close_remove_history();
private:
  void initialize_text_view();
  virtual bool is_same(const bbs_detail::Base& bbs) const;
  virtual std::string get_uri() const;

  void on_http_get_end(bool);
  void on_refresh_end(const http::StatusLine&, const http::Header&);

  void save_content(const http::Response&);
  void inform_to_board(const ThreadIdx& idx) const;

  void on_uri_clicked(const std::string& uri) const;

  boost::scoped_ptr<text_view::TextView> text_view_;
  ScrolledContainer scrolled_;
  boost::scoped_ptr<bbs_detail::Base> bbs_;
  boost::scoped_ptr<http::GetInThread> http_getter_;
  ThreadIdx idx_;
};



} // namespace dialektos


#endif
