/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_VIEW_POPUPABLE_HXX
#define TEXT_VIEW_POPUPABLE_HXX

#include <boost/unordered_set.hpp>
#include <boost/scoped_ptr.hpp>
#include "text_view_drawable.hxx"


namespace dialektos {

namespace text_element {
  class Anchor;
  class ID;
  class ResNum;
}

namespace text_view {

class Popup;

class Popupable: public dialektos::text_view::Drawable {
public:
  Popupable();
  virtual ~Popupable();

  bool on_timeout();
  bool is_pointer_on_the_element() const;
  bool is_pointer_on_the_popup() const;
protected:
  virtual void on_anchor_hovered_event(const text_element::Anchor&);
  void do_popup(const text_element::Anchor&, const LineListType& line);

private:
  virtual const LineListType& get_original_line_list() const;
  void do_id_hovered_event(const text_element::ID&);
  void do_res_num_hovered_event(const text_element::ResNum&);
  void do_anchor_hovered_event(const text_element::Anchor&);
  void build_line_list_for_popup(
      const boost::unordered_set<int>& res_nums, LineListType& target) const;

  boost::scoped_ptr<Popup> popup_;
};


} // namespace text_view

} // namespce dialektos

#endif
