/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_VIEW_POPUP_HXX
#define TEXT_VIEW_POPUP_HXX

#include <gtkmm/window.h>
#include <boost/ptr_container/ptr_vector.hpp>
#include <boost/shared_ptr.hpp>
#include "scrolled_container.hxx"
#include "text_view.hxx"


namespace dialektos {

class TextLine;

namespace text_element {
  class Anchor;
  class IDMap;
  class ResNumMap;
}


namespace text_view {


class Popup: public Gtk::Window {
  typedef boost::ptr_vector<TextLine> LineListType;

  class TextViewForPopup: public TextView {
  public:
    TextViewForPopup(const LineListType& original) :
      TextView(),
      original_line_list_(original) {
    }

    void show() {
      TextView::show();
      realize();
    }

  private:
    virtual const LineListType& get_original_line_list() const {
      return original_line_list_;
    }

    const LineListType& original_line_list_;
  };

public:
  Popup(const LineListType& line_list,
      const LineListType& original_line_list,
      const text_element::Anchor& element,
      boost::shared_ptr<text_element::IDMap> id_map,
      boost::shared_ptr<text_element::ResNumMap> res_num_map);
  bool is_same_origin(const text_element::Anchor& rhs) const;
  bool on_the_child() const;

private:
  TextViewForPopup text_view_;
  ScrolledContainer scrolled_;
  const text_element::Anchor& element_origin_;
};


} // namespace text_view

} // namespace dialektos


#endif
