/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_VIEW_POINTER_TRACKABLE_HXX
#define TEXT_VIEW_POINTER_TRACKABLE_HXX

#include "text_view_layoutable.hxx"


namespace dialektos {

namespace text_element {
  class Plain;
  class Anchor;
}

namespace text_view {


class PointerTrackable: public Layoutable {
public:
  PointerTrackable();
  virtual ~PointerTrackable();
  Glib::ustring get_selected_text() const;
protected:
  virtual bool on_button_press_event(GdkEventButton*);
  virtual bool on_button_release_event(GdkEventButton*);
  virtual bool on_motion_notify_event(GdkEventMotion*);

  virtual void on_anchor_click_event(const text_element::Anchor&);
  virtual void on_anchor_hovered_event(const text_element::Anchor&);

private:
  bool on_left_button_press_event(GdkEventButton*);
  bool on_right_button_press_event(GdkEventButton*);

  /*!
   *
   *  param x position on the widget
   *  param y position on the widget
   */
  void set_hovered(gdouble x, gdouble y);
  void set_cursor(gdouble x, gdouble y);

protected:
  const text_element::Plain* pressed_element_;
  int pressed_index_;
  const text_element::Plain* hovered_element_;
  int hovered_index_;
  const text_element::Anchor* pressed_anchor_;
};


} // namespace text_view


} // namespace dialektos

#endif
