/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_VIEW_LAYOUTABLE_HXX
#define TEXT_VIEW_LAYOUTABLE_HXX

#include <glibmm/refptr.h>
#include <pangomm/layout.h>
#include <boost/ptr_container/ptr_vector.hpp>
#include <boost/shared_ptr.hpp>
#include "text_view_scrollable.hxx"


namespace dialektos {

class TextLine;

namespace text_element {
  class Plain;
  class IDMap;
  class ResNumMap;
}

namespace text_view {


class Layoutable: public Scrollable {
public:
  typedef boost::ptr_vector<TextLine> LineListType;
  typedef boost::shared_ptr<text_element::IDMap> IDMapPtrType;
//  typedef boost::shared_ptr<const text_element::IDMap> ConstIDMapPtrType;
  typedef boost::shared_ptr<text_element::ResNumMap> ResNumMapPtrType;
//  typedef boost::shared_ptr<const text_element::ResNumMap> ConstResNumMapPtrType;

  Layoutable();
  virtual ~Layoutable();
  void relayout();
  void safe_layout();
  void add_line(TextLine*);
  void set_id_map(IDMapPtrType map) { id_map_ = map; }
  void set_res_num_map(ResNumMapPtrType map) { res_num_map_ = map; }
  IDMapPtrType get_id_map() const { return id_map_; }
  ResNumMapPtrType get_res_num_map() const { return res_num_map_; }
  void set_res_num(int res_num) { res_num_ = res_num; }
  int get_res_num() const { return res_num_; }
protected:
  //virtual bool on_expose_event(GdkEventExpose*);
  virtual bool on_configure_event(GdkEventConfigure*);
  virtual void on_realize();
  virtual void on_style_changed(const Glib::RefPtr<Gtk::Style>& previous);

  const TextLine* get_text_line(gdouble y) const;
  const TextLine* get_nearest_text_line(gdouble& y) const;
  const text_element::Plain* get_text_element(gdouble x, gdouble y) const;
  const text_element::Plain* get_nearest_text_element(gdouble& x, gdouble& y) const;

  Glib::RefPtr<Pango::Layout> pango_layout_;
  LineListType line_list_;
  boost::shared_ptr<text_element::IDMap> id_map_;
  boost::shared_ptr<text_element::ResNumMap> res_num_map_;
  int res_num_;
  Pango::FontMetrics metrics_;
  /* cached */
  gint width_;
};


} // namespace text_view


} // namespace dialektos


#endif
