/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_VIEW_DRAWING_SET_HXX
#define TEXT_VIEW_DRAWING_SET_HXX

#include <glibmm/refptr.h>
#include <gdkmm/drawable.h>
#include <gtkmm/style.h>


namespace dialektos {

namespace text_element { class Plain; }


namespace text_view {


struct LayoutSet {
  gdouble x;
  gdouble y; // y position on the adjustment

  gdouble x_start;
  gdouble x_end;
};

struct DrawingSet {
  Glib::RefPtr<Gdk::Drawable> window;
  Glib::RefPtr<const Gtk::Style> style;

  gdouble adj_value; // adjustment value

  /* for selection */
  const text_element::Plain* start_element;
  int start_index;
  const text_element::Plain* end_element;
  int end_index;
};

struct GetSelectedSet {
  const text_element::Plain* start_element;
  int start_index;
  const text_element::Plain* end_element;
  int end_index;
};


} // namespace text_view


} // namespace dialektos



#endif
