/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "text_view_drawable.hxx"

#include <glibmm/refptr.h>
#include <gdkmm/gc.h>
#include <gdkmm/drawable.h>
#include <gtkmm/style.h>
#include <boost/foreach.hpp>
#include "text_line.hxx"
#include "text_element_plain.hxx"
#include "text_view_drawing_set.hxx"


namespace dialektos {


namespace text_view {


Drawable::Drawable(): PointerTrackable() {}

Drawable::~Drawable() {}

bool Drawable::on_expose_event(GdkEventExpose* event) {
  const double value = adjustment_.get_value();
  Glib::RefPtr<Gdk::Drawable> window = get_window();
  Glib::RefPtr<const Gtk::Style> style = get_style();
  Glib::RefPtr<const Gdk::GC> gc = style->get_base_gc(Gtk::STATE_NORMAL);
  window->draw_rectangle(gc, true, 0, 0, get_width(), get_height());

  DrawingSet set;
  set.window = window;
  set.style = style;
  set.adj_value = value;
  set.start_element = pressed_element_;
  set.start_index = pressed_index_;
  set.end_element = hovered_element_;
  set.end_index = hovered_index_;

  if (pressed_element_ && hovered_element_) {
    std::pair<gdouble, gdouble> pressed_xy = pressed_element_->get_xy();
    std::pair<gdouble, gdouble> hovered_xy = hovered_element_->get_xy();

    if ((pressed_element_ == hovered_element_
        && pressed_index_ > hovered_index_) ||
        (pressed_xy.second == hovered_xy.second
            && pressed_xy.first > hovered_xy.first) ||
            (pressed_xy.second > hovered_xy.second)) {
      std::swap(set.start_element, set.end_element);
      std::swap(set.start_index, set.end_index);
    }
  }

  const int area_bottom = get_height() + value;

  BOOST_FOREACH(TextLine& line, line_list_) {
    if (line.get_y() > area_bottom) break;
    if (line.get_btm_y() >= value) line.draw(set);
  }
  return true;
}


} // namespace text_view


} // namespace dialektos
